# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.get_custom_texts_by_language_response_content import GetCustomTextsByLanguageResponseContent
from ...types.prompt_group_name_enum import PromptGroupNameEnum
from ...types.prompt_language_enum import PromptLanguageEnum
from ...types.sets_custom_texts_by_language_request_content import SetsCustomTextsByLanguageRequestContent
from .raw_client import AsyncRawCustomTextClient, RawCustomTextClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CustomTextClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCustomTextClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCustomTextClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCustomTextClient
        """
        return self._raw_client

    def get(
        self,
        prompt: PromptGroupNameEnum,
        language: PromptLanguageEnum,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetCustomTextsByLanguageResponseContent:
        """
        Retrieve custom text for a specific prompt and language.

        Parameters
        ----------
        prompt : PromptGroupNameEnum
            Name of the prompt.

        language : PromptLanguageEnum
            Language to update.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetCustomTextsByLanguageResponseContent
            Prompt dictionaries successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.prompts.custom_text.get(
            prompt="login",
            language="am",
        )
        """
        _response = self._raw_client.get(prompt, language, request_options=request_options)
        return _response.data

    def set(
        self,
        prompt: PromptGroupNameEnum,
        language: PromptLanguageEnum,
        *,
        request: SetsCustomTextsByLanguageRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Set custom text for a specific prompt. Existing texts will be overwritten.

        Parameters
        ----------
        prompt : PromptGroupNameEnum
            Name of the prompt.

        language : PromptLanguageEnum
            Language to update.

        request : SetsCustomTextsByLanguageRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.prompts.custom_text.set(
            prompt="login",
            language="am",
            request={"key": "value"},
        )
        """
        _response = self._raw_client.set(prompt, language, request=request, request_options=request_options)
        return _response.data


class AsyncCustomTextClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCustomTextClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCustomTextClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCustomTextClient
        """
        return self._raw_client

    async def get(
        self,
        prompt: PromptGroupNameEnum,
        language: PromptLanguageEnum,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetCustomTextsByLanguageResponseContent:
        """
        Retrieve custom text for a specific prompt and language.

        Parameters
        ----------
        prompt : PromptGroupNameEnum
            Name of the prompt.

        language : PromptLanguageEnum
            Language to update.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetCustomTextsByLanguageResponseContent
            Prompt dictionaries successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.prompts.custom_text.get(
                prompt="login",
                language="am",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(prompt, language, request_options=request_options)
        return _response.data

    async def set(
        self,
        prompt: PromptGroupNameEnum,
        language: PromptLanguageEnum,
        *,
        request: SetsCustomTextsByLanguageRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Set custom text for a specific prompt. Existing texts will be overwritten.

        Parameters
        ----------
        prompt : PromptGroupNameEnum
            Name of the prompt.

        language : PromptLanguageEnum
            Language to update.

        request : SetsCustomTextsByLanguageRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.prompts.custom_text.set(
                prompt="login",
                language="am",
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set(prompt, language, request=request, request_options=request_options)
        return _response.data
