# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.get_partials_response_content import GetPartialsResponseContent
from ...types.partial_groups_enum import PartialGroupsEnum
from ...types.set_partials_request_content import SetPartialsRequestContent
from .raw_client import AsyncRawPartialsClient, RawPartialsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PartialsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPartialsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPartialsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPartialsClient
        """
        return self._raw_client

    def get(
        self, prompt: PartialGroupsEnum, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetPartialsResponseContent:
        """
        Get template partials for a prompt

        Parameters
        ----------
        prompt : PartialGroupsEnum
            Name of the prompt.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetPartialsResponseContent
            Prompt partials successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.prompts.partials.get(
            prompt="login",
        )
        """
        _response = self._raw_client.get(prompt, request_options=request_options)
        return _response.data

    def set(
        self,
        prompt: PartialGroupsEnum,
        *,
        request: SetPartialsRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Set template partials for a prompt

        Parameters
        ----------
        prompt : PartialGroupsEnum
            Name of the prompt.

        request : SetPartialsRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.prompts.partials.set(
            prompt="login",
            request={"key": "value"},
        )
        """
        _response = self._raw_client.set(prompt, request=request, request_options=request_options)
        return _response.data


class AsyncPartialsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPartialsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPartialsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPartialsClient
        """
        return self._raw_client

    async def get(
        self, prompt: PartialGroupsEnum, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetPartialsResponseContent:
        """
        Get template partials for a prompt

        Parameters
        ----------
        prompt : PartialGroupsEnum
            Name of the prompt.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetPartialsResponseContent
            Prompt partials successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.prompts.partials.get(
                prompt="login",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(prompt, request_options=request_options)
        return _response.data

    async def set(
        self,
        prompt: PartialGroupsEnum,
        *,
        request: SetPartialsRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Set template partials for a prompt

        Parameters
        ----------
        prompt : PartialGroupsEnum
            Name of the prompt.

        request : SetPartialsRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.prompts.partials.set(
                prompt="login",
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set(prompt, request=request, request_options=request_options)
        return _response.data
