# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.acul_configs import AculConfigs
from ...types.acul_context_configuration import AculContextConfiguration
from ...types.acul_filters import AculFilters
from ...types.acul_head_tag import AculHeadTag
from ...types.acul_rendering_mode_enum import AculRenderingModeEnum
from ...types.acul_response_content import AculResponseContent
from ...types.bulk_update_acul_response_content import BulkUpdateAculResponseContent
from ...types.get_acul_response_content import GetAculResponseContent
from ...types.list_aculs_offset_paginated_response_content import ListAculsOffsetPaginatedResponseContent
from ...types.prompt_group_name_enum import PromptGroupNameEnum
from ...types.screen_group_name_enum import ScreenGroupNameEnum
from ...types.update_acul_response_content import UpdateAculResponseContent
from .raw_client import AsyncRawRenderingClient, RawRenderingClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RenderingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRenderingClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRenderingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRenderingClient
        """
        return self._raw_client

    def list(
        self,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        prompt: typing.Optional[str] = None,
        screen: typing.Optional[str] = None,
        rendering_mode: typing.Optional[AculRenderingModeEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[AculResponseContent, ListAculsOffsetPaginatedResponseContent]:
        """
        Get render setting configurations for all screens.

        Parameters
        ----------
        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (default: true) or excluded (false).

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Maximum value is 100, default value is 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total configuration count (true) or as a direct array of results (false, default).

        prompt : typing.Optional[str]
            Name of the prompt to filter by

        screen : typing.Optional[str]
            Name of the screen to filter by

        rendering_mode : typing.Optional[AculRenderingModeEnum]
            Rendering mode to filter by

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[AculResponseContent, ListAculsOffsetPaginatedResponseContent]
            ACUL settings successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.prompts.rendering.list(
            fields="fields",
            include_fields=True,
            page=1,
            per_page=1,
            include_totals=True,
            prompt="prompt",
            screen="screen",
            rendering_mode="advanced",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            fields=fields,
            include_fields=include_fields,
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            prompt=prompt,
            screen=screen,
            rendering_mode=rendering_mode,
            request_options=request_options,
        )

    def bulk_update(
        self, *, configs: AculConfigs, request_options: typing.Optional[RequestOptions] = None
    ) -> BulkUpdateAculResponseContent:
        """
        Learn more about <a href='https://auth0.com/docs/customize/login-pages/advanced-customizations/getting-started/configure-acul-screens'>configuring render settings</a> for advanced customization.

        Parameters
        ----------
        configs : AculConfigs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BulkUpdateAculResponseContent
            ACUL settings successfully updated.

        Examples
        --------
        from auth0 import AculConfigsItem, Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.prompts.rendering.bulk_update(
            configs=[
                AculConfigsItem(
                    prompt="login",
                    screen="login",
                )
            ],
        )
        """
        _response = self._raw_client.bulk_update(configs=configs, request_options=request_options)
        return _response.data

    def get(
        self,
        prompt: PromptGroupNameEnum,
        screen: ScreenGroupNameEnum,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetAculResponseContent:
        """
        Get render settings for a screen.

        Parameters
        ----------
        prompt : PromptGroupNameEnum
            Name of the prompt

        screen : ScreenGroupNameEnum
            Name of the screen

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAculResponseContent
            ACUL settings successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.prompts.rendering.get(
            prompt="login",
            screen="login",
        )
        """
        _response = self._raw_client.get(prompt, screen, request_options=request_options)
        return _response.data

    def update(
        self,
        prompt: PromptGroupNameEnum,
        screen: ScreenGroupNameEnum,
        *,
        rendering_mode: typing.Optional[AculRenderingModeEnum] = OMIT,
        context_configuration: typing.Optional[AculContextConfiguration] = OMIT,
        default_head_tags_disabled: typing.Optional[bool] = False,
        use_page_template: typing.Optional[bool] = False,
        head_tags: typing.Optional[typing.Sequence[AculHeadTag]] = OMIT,
        filters: typing.Optional[AculFilters] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateAculResponseContent:
        """
        Learn more about <a href='https://auth0.com/docs/customize/login-pages/advanced-customizations/getting-started/configure-acul-screens'>configuring render settings</a> for advanced customization.

        Parameters
        ----------
        prompt : PromptGroupNameEnum
            Name of the prompt

        screen : ScreenGroupNameEnum
            Name of the screen

        rendering_mode : typing.Optional[AculRenderingModeEnum]

        context_configuration : typing.Optional[AculContextConfiguration]

        default_head_tags_disabled : typing.Optional[bool]
            Override Universal Login default head tags

        use_page_template : typing.Optional[bool]
            Use page template with ACUL

        head_tags : typing.Optional[typing.Sequence[AculHeadTag]]
            An array of head tags

        filters : typing.Optional[AculFilters]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateAculResponseContent
            ACUL settings successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.prompts.rendering.update(
            prompt="login",
            screen="login",
        )
        """
        _response = self._raw_client.update(
            prompt,
            screen,
            rendering_mode=rendering_mode,
            context_configuration=context_configuration,
            default_head_tags_disabled=default_head_tags_disabled,
            use_page_template=use_page_template,
            head_tags=head_tags,
            filters=filters,
            request_options=request_options,
        )
        return _response.data


class AsyncRenderingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRenderingClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRenderingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRenderingClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        prompt: typing.Optional[str] = None,
        screen: typing.Optional[str] = None,
        rendering_mode: typing.Optional[AculRenderingModeEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[AculResponseContent, ListAculsOffsetPaginatedResponseContent]:
        """
        Get render setting configurations for all screens.

        Parameters
        ----------
        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (default: true) or excluded (false).

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Maximum value is 100, default value is 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total configuration count (true) or as a direct array of results (false, default).

        prompt : typing.Optional[str]
            Name of the prompt to filter by

        screen : typing.Optional[str]
            Name of the screen to filter by

        rendering_mode : typing.Optional[AculRenderingModeEnum]
            Rendering mode to filter by

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[AculResponseContent, ListAculsOffsetPaginatedResponseContent]
            ACUL settings successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.prompts.rendering.list(
                fields="fields",
                include_fields=True,
                page=1,
                per_page=1,
                include_totals=True,
                prompt="prompt",
                screen="screen",
                rendering_mode="advanced",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            fields=fields,
            include_fields=include_fields,
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            prompt=prompt,
            screen=screen,
            rendering_mode=rendering_mode,
            request_options=request_options,
        )

    async def bulk_update(
        self, *, configs: AculConfigs, request_options: typing.Optional[RequestOptions] = None
    ) -> BulkUpdateAculResponseContent:
        """
        Learn more about <a href='https://auth0.com/docs/customize/login-pages/advanced-customizations/getting-started/configure-acul-screens'>configuring render settings</a> for advanced customization.

        Parameters
        ----------
        configs : AculConfigs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BulkUpdateAculResponseContent
            ACUL settings successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AculConfigsItem, AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.prompts.rendering.bulk_update(
                configs=[
                    AculConfigsItem(
                        prompt="login",
                        screen="login",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.bulk_update(configs=configs, request_options=request_options)
        return _response.data

    async def get(
        self,
        prompt: PromptGroupNameEnum,
        screen: ScreenGroupNameEnum,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetAculResponseContent:
        """
        Get render settings for a screen.

        Parameters
        ----------
        prompt : PromptGroupNameEnum
            Name of the prompt

        screen : ScreenGroupNameEnum
            Name of the screen

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAculResponseContent
            ACUL settings successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.prompts.rendering.get(
                prompt="login",
                screen="login",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(prompt, screen, request_options=request_options)
        return _response.data

    async def update(
        self,
        prompt: PromptGroupNameEnum,
        screen: ScreenGroupNameEnum,
        *,
        rendering_mode: typing.Optional[AculRenderingModeEnum] = OMIT,
        context_configuration: typing.Optional[AculContextConfiguration] = OMIT,
        default_head_tags_disabled: typing.Optional[bool] = False,
        use_page_template: typing.Optional[bool] = False,
        head_tags: typing.Optional[typing.Sequence[AculHeadTag]] = OMIT,
        filters: typing.Optional[AculFilters] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateAculResponseContent:
        """
        Learn more about <a href='https://auth0.com/docs/customize/login-pages/advanced-customizations/getting-started/configure-acul-screens'>configuring render settings</a> for advanced customization.

        Parameters
        ----------
        prompt : PromptGroupNameEnum
            Name of the prompt

        screen : ScreenGroupNameEnum
            Name of the screen

        rendering_mode : typing.Optional[AculRenderingModeEnum]

        context_configuration : typing.Optional[AculContextConfiguration]

        default_head_tags_disabled : typing.Optional[bool]
            Override Universal Login default head tags

        use_page_template : typing.Optional[bool]
            Use page template with ACUL

        head_tags : typing.Optional[typing.Sequence[AculHeadTag]]
            An array of head tags

        filters : typing.Optional[AculFilters]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateAculResponseContent
            ACUL settings successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.prompts.rendering.update(
                prompt="login",
                screen="login",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            prompt,
            screen,
            rendering_mode=rendering_mode,
            context_configuration=context_configuration,
            default_head_tags_disabled=default_head_tags_disabled,
            use_page_template=use_page_template,
            head_tags=head_tags,
            filters=filters,
            request_options=request_options,
        )
        return _response.data
