# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pagination import AsyncPager, SyncPager
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.bad_request_error import BadRequestError
from ...errors.forbidden_error import ForbiddenError
from ...errors.not_found_error import NotFoundError
from ...errors.payment_required_error import PaymentRequiredError
from ...errors.too_many_requests_error import TooManyRequestsError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.acul_configs import AculConfigs
from ...types.acul_context_configuration import AculContextConfiguration
from ...types.acul_filters import AculFilters
from ...types.acul_head_tag import AculHeadTag
from ...types.acul_rendering_mode_enum import AculRenderingModeEnum
from ...types.acul_response_content import AculResponseContent
from ...types.bulk_update_acul_response_content import BulkUpdateAculResponseContent
from ...types.get_acul_response_content import GetAculResponseContent
from ...types.list_aculs_offset_paginated_response_content import ListAculsOffsetPaginatedResponseContent
from ...types.prompt_group_name_enum import PromptGroupNameEnum
from ...types.screen_group_name_enum import ScreenGroupNameEnum
from ...types.update_acul_response_content import UpdateAculResponseContent

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawRenderingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        prompt: typing.Optional[str] = None,
        screen: typing.Optional[str] = None,
        rendering_mode: typing.Optional[AculRenderingModeEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[AculResponseContent, ListAculsOffsetPaginatedResponseContent]:
        """
        Get render setting configurations for all screens.

        Parameters
        ----------
        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (default: true) or excluded (false).

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Maximum value is 100, default value is 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total configuration count (true) or as a direct array of results (false, default).

        prompt : typing.Optional[str]
            Name of the prompt to filter by

        screen : typing.Optional[str]
            Name of the screen to filter by

        rendering_mode : typing.Optional[AculRenderingModeEnum]
            Rendering mode to filter by

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[AculResponseContent, ListAculsOffsetPaginatedResponseContent]
            ACUL settings successfully retrieved.
        """
        page = page if page is not None else 0

        _response = self._client_wrapper.httpx_client.request(
            "prompts/rendering",
            method="GET",
            params={
                "fields": fields,
                "include_fields": include_fields,
                "page": page,
                "per_page": per_page,
                "include_totals": include_totals,
                "prompt": prompt,
                "screen": screen,
                "rendering_mode": rendering_mode,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListAculsOffsetPaginatedResponseContent,
                    parse_obj_as(
                        type_=ListAculsOffsetPaginatedResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.configs
                _has_next = True
                _get_next = lambda: self.list(
                    fields=fields,
                    include_fields=include_fields,
                    page=page + len(_items or []),
                    per_page=per_page,
                    include_totals=include_totals,
                    prompt=prompt,
                    screen=screen,
                    rendering_mode=rendering_mode,
                    request_options=request_options,
                )
                return SyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 402:
                raise PaymentRequiredError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def bulk_update(
        self, *, configs: AculConfigs, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[BulkUpdateAculResponseContent]:
        """
        Learn more about <a href='https://auth0.com/docs/customize/login-pages/advanced-customizations/getting-started/configure-acul-screens'>configuring render settings</a> for advanced customization.

        Parameters
        ----------
        configs : AculConfigs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[BulkUpdateAculResponseContent]
            ACUL settings successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "prompts/rendering",
            method="PATCH",
            json={
                "configs": convert_and_respect_annotation_metadata(
                    object_=configs, annotation=AculConfigs, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BulkUpdateAculResponseContent,
                    parse_obj_as(
                        type_=BulkUpdateAculResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 402:
                raise PaymentRequiredError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self,
        prompt: PromptGroupNameEnum,
        screen: ScreenGroupNameEnum,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetAculResponseContent]:
        """
        Get render settings for a screen.

        Parameters
        ----------
        prompt : PromptGroupNameEnum
            Name of the prompt

        screen : ScreenGroupNameEnum
            Name of the screen

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetAculResponseContent]
            ACUL settings successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"prompts/{jsonable_encoder(prompt)}/screen/{jsonable_encoder(screen)}/rendering",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetAculResponseContent,
                    parse_obj_as(
                        type_=GetAculResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 402:
                raise PaymentRequiredError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        prompt: PromptGroupNameEnum,
        screen: ScreenGroupNameEnum,
        *,
        rendering_mode: typing.Optional[AculRenderingModeEnum] = OMIT,
        context_configuration: typing.Optional[AculContextConfiguration] = OMIT,
        default_head_tags_disabled: typing.Optional[bool] = False,
        use_page_template: typing.Optional[bool] = False,
        head_tags: typing.Optional[typing.Sequence[AculHeadTag]] = OMIT,
        filters: typing.Optional[AculFilters] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateAculResponseContent]:
        """
        Learn more about <a href='https://auth0.com/docs/customize/login-pages/advanced-customizations/getting-started/configure-acul-screens'>configuring render settings</a> for advanced customization.

        Parameters
        ----------
        prompt : PromptGroupNameEnum
            Name of the prompt

        screen : ScreenGroupNameEnum
            Name of the screen

        rendering_mode : typing.Optional[AculRenderingModeEnum]

        context_configuration : typing.Optional[AculContextConfiguration]

        default_head_tags_disabled : typing.Optional[bool]
            Override Universal Login default head tags

        use_page_template : typing.Optional[bool]
            Use page template with ACUL

        head_tags : typing.Optional[typing.Sequence[AculHeadTag]]
            An array of head tags

        filters : typing.Optional[AculFilters]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateAculResponseContent]
            ACUL settings successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"prompts/{jsonable_encoder(prompt)}/screen/{jsonable_encoder(screen)}/rendering",
            method="PATCH",
            json={
                "rendering_mode": rendering_mode,
                "context_configuration": convert_and_respect_annotation_metadata(
                    object_=context_configuration, annotation=AculContextConfiguration, direction="write"
                ),
                "default_head_tags_disabled": default_head_tags_disabled,
                "use_page_template": use_page_template,
                "head_tags": convert_and_respect_annotation_metadata(
                    object_=head_tags, annotation=typing.Sequence[AculHeadTag], direction="write"
                ),
                "filters": convert_and_respect_annotation_metadata(
                    object_=filters, annotation=typing.Optional[AculFilters], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateAculResponseContent,
                    parse_obj_as(
                        type_=UpdateAculResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 402:
                raise PaymentRequiredError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawRenderingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        prompt: typing.Optional[str] = None,
        screen: typing.Optional[str] = None,
        rendering_mode: typing.Optional[AculRenderingModeEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[AculResponseContent, ListAculsOffsetPaginatedResponseContent]:
        """
        Get render setting configurations for all screens.

        Parameters
        ----------
        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (default: true) or excluded (false).

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Maximum value is 100, default value is 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total configuration count (true) or as a direct array of results (false, default).

        prompt : typing.Optional[str]
            Name of the prompt to filter by

        screen : typing.Optional[str]
            Name of the screen to filter by

        rendering_mode : typing.Optional[AculRenderingModeEnum]
            Rendering mode to filter by

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[AculResponseContent, ListAculsOffsetPaginatedResponseContent]
            ACUL settings successfully retrieved.
        """
        page = page if page is not None else 0

        _response = await self._client_wrapper.httpx_client.request(
            "prompts/rendering",
            method="GET",
            params={
                "fields": fields,
                "include_fields": include_fields,
                "page": page,
                "per_page": per_page,
                "include_totals": include_totals,
                "prompt": prompt,
                "screen": screen,
                "rendering_mode": rendering_mode,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListAculsOffsetPaginatedResponseContent,
                    parse_obj_as(
                        type_=ListAculsOffsetPaginatedResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.configs
                _has_next = True

                async def _get_next():
                    return await self.list(
                        fields=fields,
                        include_fields=include_fields,
                        page=page + len(_items or []),
                        per_page=per_page,
                        include_totals=include_totals,
                        prompt=prompt,
                        screen=screen,
                        rendering_mode=rendering_mode,
                        request_options=request_options,
                    )

                return AsyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 402:
                raise PaymentRequiredError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def bulk_update(
        self, *, configs: AculConfigs, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[BulkUpdateAculResponseContent]:
        """
        Learn more about <a href='https://auth0.com/docs/customize/login-pages/advanced-customizations/getting-started/configure-acul-screens'>configuring render settings</a> for advanced customization.

        Parameters
        ----------
        configs : AculConfigs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[BulkUpdateAculResponseContent]
            ACUL settings successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "prompts/rendering",
            method="PATCH",
            json={
                "configs": convert_and_respect_annotation_metadata(
                    object_=configs, annotation=AculConfigs, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BulkUpdateAculResponseContent,
                    parse_obj_as(
                        type_=BulkUpdateAculResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 402:
                raise PaymentRequiredError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self,
        prompt: PromptGroupNameEnum,
        screen: ScreenGroupNameEnum,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetAculResponseContent]:
        """
        Get render settings for a screen.

        Parameters
        ----------
        prompt : PromptGroupNameEnum
            Name of the prompt

        screen : ScreenGroupNameEnum
            Name of the screen

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetAculResponseContent]
            ACUL settings successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"prompts/{jsonable_encoder(prompt)}/screen/{jsonable_encoder(screen)}/rendering",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetAculResponseContent,
                    parse_obj_as(
                        type_=GetAculResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 402:
                raise PaymentRequiredError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        prompt: PromptGroupNameEnum,
        screen: ScreenGroupNameEnum,
        *,
        rendering_mode: typing.Optional[AculRenderingModeEnum] = OMIT,
        context_configuration: typing.Optional[AculContextConfiguration] = OMIT,
        default_head_tags_disabled: typing.Optional[bool] = False,
        use_page_template: typing.Optional[bool] = False,
        head_tags: typing.Optional[typing.Sequence[AculHeadTag]] = OMIT,
        filters: typing.Optional[AculFilters] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateAculResponseContent]:
        """
        Learn more about <a href='https://auth0.com/docs/customize/login-pages/advanced-customizations/getting-started/configure-acul-screens'>configuring render settings</a> for advanced customization.

        Parameters
        ----------
        prompt : PromptGroupNameEnum
            Name of the prompt

        screen : ScreenGroupNameEnum
            Name of the screen

        rendering_mode : typing.Optional[AculRenderingModeEnum]

        context_configuration : typing.Optional[AculContextConfiguration]

        default_head_tags_disabled : typing.Optional[bool]
            Override Universal Login default head tags

        use_page_template : typing.Optional[bool]
            Use page template with ACUL

        head_tags : typing.Optional[typing.Sequence[AculHeadTag]]
            An array of head tags

        filters : typing.Optional[AculFilters]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateAculResponseContent]
            ACUL settings successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"prompts/{jsonable_encoder(prompt)}/screen/{jsonable_encoder(screen)}/rendering",
            method="PATCH",
            json={
                "rendering_mode": rendering_mode,
                "context_configuration": convert_and_respect_annotation_metadata(
                    object_=context_configuration, annotation=AculContextConfiguration, direction="write"
                ),
                "default_head_tags_disabled": default_head_tags_disabled,
                "use_page_template": use_page_template,
                "head_tags": convert_and_respect_annotation_metadata(
                    object_=head_tags, annotation=typing.Sequence[AculHeadTag], direction="write"
                ),
                "filters": convert_and_respect_annotation_metadata(
                    object_=filters, annotation=typing.Optional[AculFilters], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateAculResponseContent,
                    parse_obj_as(
                        type_=UpdateAculResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 402:
                raise PaymentRequiredError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
