# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.get_refresh_token_response_content import GetRefreshTokenResponseContent
from .raw_client import AsyncRawRefreshTokensClient, RawRefreshTokensClient


class RefreshTokensClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRefreshTokensClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRefreshTokensClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRefreshTokensClient
        """
        return self._raw_client

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetRefreshTokenResponseContent:
        """
        Retrieve refresh token information.

        Parameters
        ----------
        id : str
            ID refresh token to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetRefreshTokenResponseContent
            The refresh token was retrieved

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.refresh_tokens.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a refresh token by its ID.

        Parameters
        ----------
        id : str
            ID of the refresh token to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.refresh_tokens.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data


class AsyncRefreshTokensClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRefreshTokensClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRefreshTokensClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRefreshTokensClient
        """
        return self._raw_client

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetRefreshTokenResponseContent:
        """
        Retrieve refresh token information.

        Parameters
        ----------
        id : str
            ID refresh token to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetRefreshTokenResponseContent
            The refresh token was retrieved

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.refresh_tokens.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a refresh token by its ID.

        Parameters
        ----------
        id : str
            ID of the refresh token to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.refresh_tokens.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data
