# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.create_resource_server_response_content import CreateResourceServerResponseContent
from ..types.get_resource_server_response_content import GetResourceServerResponseContent
from ..types.list_resource_server_offset_paginated_response_content import (
    ListResourceServerOffsetPaginatedResponseContent,
)
from ..types.resource_server import ResourceServer
from ..types.resource_server_consent_policy_enum import ResourceServerConsentPolicyEnum
from ..types.resource_server_proof_of_possession import ResourceServerProofOfPossession
from ..types.resource_server_scope import ResourceServerScope
from ..types.resource_server_subject_type_authorization import ResourceServerSubjectTypeAuthorization
from ..types.resource_server_token_dialect_schema_enum import ResourceServerTokenDialectSchemaEnum
from ..types.resource_server_token_encryption import ResourceServerTokenEncryption
from ..types.signing_algorithm_enum import SigningAlgorithmEnum
from ..types.update_resource_server_response_content import UpdateResourceServerResponseContent
from .raw_client import AsyncRawResourceServersClient, RawResourceServersClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ResourceServersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawResourceServersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawResourceServersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawResourceServersClient
        """
        return self._raw_client

    def list(
        self,
        *,
        identifiers: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ResourceServer, ListResourceServerOffsetPaginatedResponseContent]:
        """
        Retrieve details of all APIs associated with your tenant.

        Parameters
        ----------
        identifiers : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            An optional filter on the resource server identifier. Must be URL encoded and may be specified multiple times (max 10).<br /><b>e.g.</b> <i>../resource-servers?identifiers=id1&identifiers=id2</i>

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ResourceServer, ListResourceServerOffsetPaginatedResponseContent]
            Resource servers successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.resource_servers.list(
            page=1,
            per_page=1,
            include_totals=True,
            include_fields=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            identifiers=identifiers,
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            include_fields=include_fields,
            request_options=request_options,
        )

    def create(
        self,
        *,
        identifier: str,
        name: typing.Optional[str] = OMIT,
        scopes: typing.Optional[typing.Sequence[ResourceServerScope]] = OMIT,
        signing_alg: typing.Optional[SigningAlgorithmEnum] = OMIT,
        signing_secret: typing.Optional[str] = OMIT,
        allow_offline_access: typing.Optional[bool] = OMIT,
        token_lifetime: typing.Optional[int] = OMIT,
        token_dialect: typing.Optional[ResourceServerTokenDialectSchemaEnum] = OMIT,
        skip_consent_for_verifiable_first_party_clients: typing.Optional[bool] = OMIT,
        enforce_policies: typing.Optional[bool] = OMIT,
        token_encryption: typing.Optional[ResourceServerTokenEncryption] = OMIT,
        consent_policy: typing.Optional[ResourceServerConsentPolicyEnum] = OMIT,
        authorization_details: typing.Optional[typing.Sequence[typing.Any]] = OMIT,
        proof_of_possession: typing.Optional[ResourceServerProofOfPossession] = OMIT,
        subject_type_authorization: typing.Optional[ResourceServerSubjectTypeAuthorization] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateResourceServerResponseContent:
        """
        Create a new API associated with your tenant. Note that all new APIs must be registered with Auth0. For more information, read <a href="https://www.auth0.com/docs/get-started/apis"> APIs</a>.

        Parameters
        ----------
        identifier : str
            Unique identifier for the API used as the audience parameter on authorization calls. Can not be changed once set.

        name : typing.Optional[str]
            Friendly name for this resource server. Can not contain `<` or `>` characters.

        scopes : typing.Optional[typing.Sequence[ResourceServerScope]]
            List of permissions (scopes) that this API uses.

        signing_alg : typing.Optional[SigningAlgorithmEnum]

        signing_secret : typing.Optional[str]
            Secret used to sign tokens when using symmetric algorithms (HS256).

        allow_offline_access : typing.Optional[bool]
            Whether refresh tokens can be issued for this API (true) or not (false).

        token_lifetime : typing.Optional[int]
            Expiration value (in seconds) for access tokens issued for this API from the token endpoint.

        token_dialect : typing.Optional[ResourceServerTokenDialectSchemaEnum]

        skip_consent_for_verifiable_first_party_clients : typing.Optional[bool]
            Whether to skip user consent for applications flagged as first party (true) or not (false).

        enforce_policies : typing.Optional[bool]
            Whether to enforce authorization policies (true) or to ignore them (false).

        token_encryption : typing.Optional[ResourceServerTokenEncryption]

        consent_policy : typing.Optional[ResourceServerConsentPolicyEnum]

        authorization_details : typing.Optional[typing.Sequence[typing.Any]]

        proof_of_possession : typing.Optional[ResourceServerProofOfPossession]

        subject_type_authorization : typing.Optional[ResourceServerSubjectTypeAuthorization]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateResourceServerResponseContent
            Resource server successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.resource_servers.create(
            identifier="identifier",
        )
        """
        _response = self._raw_client.create(
            identifier=identifier,
            name=name,
            scopes=scopes,
            signing_alg=signing_alg,
            signing_secret=signing_secret,
            allow_offline_access=allow_offline_access,
            token_lifetime=token_lifetime,
            token_dialect=token_dialect,
            skip_consent_for_verifiable_first_party_clients=skip_consent_for_verifiable_first_party_clients,
            enforce_policies=enforce_policies,
            token_encryption=token_encryption,
            consent_policy=consent_policy,
            authorization_details=authorization_details,
            proof_of_possession=proof_of_possession,
            subject_type_authorization=subject_type_authorization,
            request_options=request_options,
        )
        return _response.data

    def get(
        self,
        id: str,
        *,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetResourceServerResponseContent:
        """
        Retrieve <a href="https://auth0.com/docs/apis">API</a> details with the given ID.

        Parameters
        ----------
        id : str
            ID or audience of the resource server to retrieve.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetResourceServerResponseContent
            Resource server successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.resource_servers.get(
            id="id",
            include_fields=True,
        )
        """
        _response = self._raw_client.get(id, include_fields=include_fields, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete an existing API by ID. For more information, read <a href="https://www.auth0.com/docs/get-started/apis/api-settings">API Settings</a>.

        Parameters
        ----------
        id : str
            ID or the audience of the resource server to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.resource_servers.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        scopes: typing.Optional[typing.Sequence[ResourceServerScope]] = OMIT,
        signing_alg: typing.Optional[SigningAlgorithmEnum] = OMIT,
        signing_secret: typing.Optional[str] = OMIT,
        skip_consent_for_verifiable_first_party_clients: typing.Optional[bool] = OMIT,
        allow_offline_access: typing.Optional[bool] = OMIT,
        token_lifetime: typing.Optional[int] = OMIT,
        token_dialect: typing.Optional[ResourceServerTokenDialectSchemaEnum] = OMIT,
        enforce_policies: typing.Optional[bool] = OMIT,
        token_encryption: typing.Optional[ResourceServerTokenEncryption] = OMIT,
        consent_policy: typing.Optional[ResourceServerConsentPolicyEnum] = OMIT,
        authorization_details: typing.Optional[typing.Sequence[typing.Any]] = OMIT,
        proof_of_possession: typing.Optional[ResourceServerProofOfPossession] = OMIT,
        subject_type_authorization: typing.Optional[ResourceServerSubjectTypeAuthorization] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateResourceServerResponseContent:
        """
        Change an existing API setting by resource server ID. For more information, read <a href="https://www.auth0.com/docs/get-started/apis/api-settings">API Settings</a>.

        Parameters
        ----------
        id : str
            ID or audience of the resource server to update.

        name : typing.Optional[str]
            Friendly name for this resource server. Can not contain `<` or `>` characters.

        scopes : typing.Optional[typing.Sequence[ResourceServerScope]]
            List of permissions (scopes) that this API uses.

        signing_alg : typing.Optional[SigningAlgorithmEnum]

        signing_secret : typing.Optional[str]
            Secret used to sign tokens when using symmetric algorithms (HS256).

        skip_consent_for_verifiable_first_party_clients : typing.Optional[bool]
            Whether to skip user consent for applications flagged as first party (true) or not (false).

        allow_offline_access : typing.Optional[bool]
            Whether refresh tokens can be issued for this API (true) or not (false).

        token_lifetime : typing.Optional[int]
            Expiration value (in seconds) for access tokens issued for this API from the token endpoint.

        token_dialect : typing.Optional[ResourceServerTokenDialectSchemaEnum]

        enforce_policies : typing.Optional[bool]
            Whether authorization policies are enforced (true) or not enforced (false).

        token_encryption : typing.Optional[ResourceServerTokenEncryption]

        consent_policy : typing.Optional[ResourceServerConsentPolicyEnum]

        authorization_details : typing.Optional[typing.Sequence[typing.Any]]

        proof_of_possession : typing.Optional[ResourceServerProofOfPossession]

        subject_type_authorization : typing.Optional[ResourceServerSubjectTypeAuthorization]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateResourceServerResponseContent
            Resource server successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.resource_servers.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            name=name,
            scopes=scopes,
            signing_alg=signing_alg,
            signing_secret=signing_secret,
            skip_consent_for_verifiable_first_party_clients=skip_consent_for_verifiable_first_party_clients,
            allow_offline_access=allow_offline_access,
            token_lifetime=token_lifetime,
            token_dialect=token_dialect,
            enforce_policies=enforce_policies,
            token_encryption=token_encryption,
            consent_policy=consent_policy,
            authorization_details=authorization_details,
            proof_of_possession=proof_of_possession,
            subject_type_authorization=subject_type_authorization,
            request_options=request_options,
        )
        return _response.data


class AsyncResourceServersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawResourceServersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawResourceServersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawResourceServersClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        identifiers: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ResourceServer, ListResourceServerOffsetPaginatedResponseContent]:
        """
        Retrieve details of all APIs associated with your tenant.

        Parameters
        ----------
        identifiers : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            An optional filter on the resource server identifier. Must be URL encoded and may be specified multiple times (max 10).<br /><b>e.g.</b> <i>../resource-servers?identifiers=id1&identifiers=id2</i>

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ResourceServer, ListResourceServerOffsetPaginatedResponseContent]
            Resource servers successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.resource_servers.list(
                page=1,
                per_page=1,
                include_totals=True,
                include_fields=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            identifiers=identifiers,
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            include_fields=include_fields,
            request_options=request_options,
        )

    async def create(
        self,
        *,
        identifier: str,
        name: typing.Optional[str] = OMIT,
        scopes: typing.Optional[typing.Sequence[ResourceServerScope]] = OMIT,
        signing_alg: typing.Optional[SigningAlgorithmEnum] = OMIT,
        signing_secret: typing.Optional[str] = OMIT,
        allow_offline_access: typing.Optional[bool] = OMIT,
        token_lifetime: typing.Optional[int] = OMIT,
        token_dialect: typing.Optional[ResourceServerTokenDialectSchemaEnum] = OMIT,
        skip_consent_for_verifiable_first_party_clients: typing.Optional[bool] = OMIT,
        enforce_policies: typing.Optional[bool] = OMIT,
        token_encryption: typing.Optional[ResourceServerTokenEncryption] = OMIT,
        consent_policy: typing.Optional[ResourceServerConsentPolicyEnum] = OMIT,
        authorization_details: typing.Optional[typing.Sequence[typing.Any]] = OMIT,
        proof_of_possession: typing.Optional[ResourceServerProofOfPossession] = OMIT,
        subject_type_authorization: typing.Optional[ResourceServerSubjectTypeAuthorization] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateResourceServerResponseContent:
        """
        Create a new API associated with your tenant. Note that all new APIs must be registered with Auth0. For more information, read <a href="https://www.auth0.com/docs/get-started/apis"> APIs</a>.

        Parameters
        ----------
        identifier : str
            Unique identifier for the API used as the audience parameter on authorization calls. Can not be changed once set.

        name : typing.Optional[str]
            Friendly name for this resource server. Can not contain `<` or `>` characters.

        scopes : typing.Optional[typing.Sequence[ResourceServerScope]]
            List of permissions (scopes) that this API uses.

        signing_alg : typing.Optional[SigningAlgorithmEnum]

        signing_secret : typing.Optional[str]
            Secret used to sign tokens when using symmetric algorithms (HS256).

        allow_offline_access : typing.Optional[bool]
            Whether refresh tokens can be issued for this API (true) or not (false).

        token_lifetime : typing.Optional[int]
            Expiration value (in seconds) for access tokens issued for this API from the token endpoint.

        token_dialect : typing.Optional[ResourceServerTokenDialectSchemaEnum]

        skip_consent_for_verifiable_first_party_clients : typing.Optional[bool]
            Whether to skip user consent for applications flagged as first party (true) or not (false).

        enforce_policies : typing.Optional[bool]
            Whether to enforce authorization policies (true) or to ignore them (false).

        token_encryption : typing.Optional[ResourceServerTokenEncryption]

        consent_policy : typing.Optional[ResourceServerConsentPolicyEnum]

        authorization_details : typing.Optional[typing.Sequence[typing.Any]]

        proof_of_possession : typing.Optional[ResourceServerProofOfPossession]

        subject_type_authorization : typing.Optional[ResourceServerSubjectTypeAuthorization]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateResourceServerResponseContent
            Resource server successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.resource_servers.create(
                identifier="identifier",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            identifier=identifier,
            name=name,
            scopes=scopes,
            signing_alg=signing_alg,
            signing_secret=signing_secret,
            allow_offline_access=allow_offline_access,
            token_lifetime=token_lifetime,
            token_dialect=token_dialect,
            skip_consent_for_verifiable_first_party_clients=skip_consent_for_verifiable_first_party_clients,
            enforce_policies=enforce_policies,
            token_encryption=token_encryption,
            consent_policy=consent_policy,
            authorization_details=authorization_details,
            proof_of_possession=proof_of_possession,
            subject_type_authorization=subject_type_authorization,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self,
        id: str,
        *,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetResourceServerResponseContent:
        """
        Retrieve <a href="https://auth0.com/docs/apis">API</a> details with the given ID.

        Parameters
        ----------
        id : str
            ID or audience of the resource server to retrieve.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetResourceServerResponseContent
            Resource server successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.resource_servers.get(
                id="id",
                include_fields=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, include_fields=include_fields, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete an existing API by ID. For more information, read <a href="https://www.auth0.com/docs/get-started/apis/api-settings">API Settings</a>.

        Parameters
        ----------
        id : str
            ID or the audience of the resource server to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.resource_servers.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        scopes: typing.Optional[typing.Sequence[ResourceServerScope]] = OMIT,
        signing_alg: typing.Optional[SigningAlgorithmEnum] = OMIT,
        signing_secret: typing.Optional[str] = OMIT,
        skip_consent_for_verifiable_first_party_clients: typing.Optional[bool] = OMIT,
        allow_offline_access: typing.Optional[bool] = OMIT,
        token_lifetime: typing.Optional[int] = OMIT,
        token_dialect: typing.Optional[ResourceServerTokenDialectSchemaEnum] = OMIT,
        enforce_policies: typing.Optional[bool] = OMIT,
        token_encryption: typing.Optional[ResourceServerTokenEncryption] = OMIT,
        consent_policy: typing.Optional[ResourceServerConsentPolicyEnum] = OMIT,
        authorization_details: typing.Optional[typing.Sequence[typing.Any]] = OMIT,
        proof_of_possession: typing.Optional[ResourceServerProofOfPossession] = OMIT,
        subject_type_authorization: typing.Optional[ResourceServerSubjectTypeAuthorization] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateResourceServerResponseContent:
        """
        Change an existing API setting by resource server ID. For more information, read <a href="https://www.auth0.com/docs/get-started/apis/api-settings">API Settings</a>.

        Parameters
        ----------
        id : str
            ID or audience of the resource server to update.

        name : typing.Optional[str]
            Friendly name for this resource server. Can not contain `<` or `>` characters.

        scopes : typing.Optional[typing.Sequence[ResourceServerScope]]
            List of permissions (scopes) that this API uses.

        signing_alg : typing.Optional[SigningAlgorithmEnum]

        signing_secret : typing.Optional[str]
            Secret used to sign tokens when using symmetric algorithms (HS256).

        skip_consent_for_verifiable_first_party_clients : typing.Optional[bool]
            Whether to skip user consent for applications flagged as first party (true) or not (false).

        allow_offline_access : typing.Optional[bool]
            Whether refresh tokens can be issued for this API (true) or not (false).

        token_lifetime : typing.Optional[int]
            Expiration value (in seconds) for access tokens issued for this API from the token endpoint.

        token_dialect : typing.Optional[ResourceServerTokenDialectSchemaEnum]

        enforce_policies : typing.Optional[bool]
            Whether authorization policies are enforced (true) or not enforced (false).

        token_encryption : typing.Optional[ResourceServerTokenEncryption]

        consent_policy : typing.Optional[ResourceServerConsentPolicyEnum]

        authorization_details : typing.Optional[typing.Sequence[typing.Any]]

        proof_of_possession : typing.Optional[ResourceServerProofOfPossession]

        subject_type_authorization : typing.Optional[ResourceServerSubjectTypeAuthorization]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateResourceServerResponseContent
            Resource server successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.resource_servers.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            name=name,
            scopes=scopes,
            signing_alg=signing_alg,
            signing_secret=signing_secret,
            skip_consent_for_verifiable_first_party_clients=skip_consent_for_verifiable_first_party_clients,
            allow_offline_access=allow_offline_access,
            token_lifetime=token_lifetime,
            token_dialect=token_dialect,
            enforce_policies=enforce_policies,
            token_encryption=token_encryption,
            consent_policy=consent_policy,
            authorization_details=authorization_details,
            proof_of_possession=proof_of_possession,
            subject_type_authorization=subject_type_authorization,
            request_options=request_options,
        )
        return _response.data
