# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pagination import AsyncPager, SyncPager
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.bad_request_error import BadRequestError
from ..errors.conflict_error import ConflictError
from ..errors.forbidden_error import ForbiddenError
from ..errors.not_found_error import NotFoundError
from ..errors.too_many_requests_error import TooManyRequestsError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.create_resource_server_response_content import CreateResourceServerResponseContent
from ..types.get_resource_server_response_content import GetResourceServerResponseContent
from ..types.list_resource_server_offset_paginated_response_content import (
    ListResourceServerOffsetPaginatedResponseContent,
)
from ..types.resource_server import ResourceServer
from ..types.resource_server_consent_policy_enum import ResourceServerConsentPolicyEnum
from ..types.resource_server_proof_of_possession import ResourceServerProofOfPossession
from ..types.resource_server_scope import ResourceServerScope
from ..types.resource_server_subject_type_authorization import ResourceServerSubjectTypeAuthorization
from ..types.resource_server_token_dialect_schema_enum import ResourceServerTokenDialectSchemaEnum
from ..types.resource_server_token_encryption import ResourceServerTokenEncryption
from ..types.signing_algorithm_enum import SigningAlgorithmEnum
from ..types.update_resource_server_response_content import UpdateResourceServerResponseContent

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawResourceServersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        identifiers: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ResourceServer, ListResourceServerOffsetPaginatedResponseContent]:
        """
        Retrieve details of all APIs associated with your tenant.

        Parameters
        ----------
        identifiers : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            An optional filter on the resource server identifier. Must be URL encoded and may be specified multiple times (max 10).<br /><b>e.g.</b> <i>../resource-servers?identifiers=id1&identifiers=id2</i>

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ResourceServer, ListResourceServerOffsetPaginatedResponseContent]
            Resource servers successfully retrieved.
        """
        page = page if page is not None else 0

        _response = self._client_wrapper.httpx_client.request(
            "resource-servers",
            method="GET",
            params={
                "identifiers": identifiers,
                "page": page,
                "per_page": per_page,
                "include_totals": include_totals,
                "include_fields": include_fields,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListResourceServerOffsetPaginatedResponseContent,
                    parse_obj_as(
                        type_=ListResourceServerOffsetPaginatedResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.resource_servers
                _has_next = True
                _get_next = lambda: self.list(
                    identifiers=identifiers,
                    page=page + len(_items or []),
                    per_page=per_page,
                    include_totals=include_totals,
                    include_fields=include_fields,
                    request_options=request_options,
                )
                return SyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        identifier: str,
        name: typing.Optional[str] = OMIT,
        scopes: typing.Optional[typing.Sequence[ResourceServerScope]] = OMIT,
        signing_alg: typing.Optional[SigningAlgorithmEnum] = OMIT,
        signing_secret: typing.Optional[str] = OMIT,
        allow_offline_access: typing.Optional[bool] = OMIT,
        token_lifetime: typing.Optional[int] = OMIT,
        token_dialect: typing.Optional[ResourceServerTokenDialectSchemaEnum] = OMIT,
        skip_consent_for_verifiable_first_party_clients: typing.Optional[bool] = OMIT,
        enforce_policies: typing.Optional[bool] = OMIT,
        token_encryption: typing.Optional[ResourceServerTokenEncryption] = OMIT,
        consent_policy: typing.Optional[ResourceServerConsentPolicyEnum] = OMIT,
        authorization_details: typing.Optional[typing.Sequence[typing.Any]] = OMIT,
        proof_of_possession: typing.Optional[ResourceServerProofOfPossession] = OMIT,
        subject_type_authorization: typing.Optional[ResourceServerSubjectTypeAuthorization] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateResourceServerResponseContent]:
        """
        Create a new API associated with your tenant. Note that all new APIs must be registered with Auth0. For more information, read <a href="https://www.auth0.com/docs/get-started/apis"> APIs</a>.

        Parameters
        ----------
        identifier : str
            Unique identifier for the API used as the audience parameter on authorization calls. Can not be changed once set.

        name : typing.Optional[str]
            Friendly name for this resource server. Can not contain `<` or `>` characters.

        scopes : typing.Optional[typing.Sequence[ResourceServerScope]]
            List of permissions (scopes) that this API uses.

        signing_alg : typing.Optional[SigningAlgorithmEnum]

        signing_secret : typing.Optional[str]
            Secret used to sign tokens when using symmetric algorithms (HS256).

        allow_offline_access : typing.Optional[bool]
            Whether refresh tokens can be issued for this API (true) or not (false).

        token_lifetime : typing.Optional[int]
            Expiration value (in seconds) for access tokens issued for this API from the token endpoint.

        token_dialect : typing.Optional[ResourceServerTokenDialectSchemaEnum]

        skip_consent_for_verifiable_first_party_clients : typing.Optional[bool]
            Whether to skip user consent for applications flagged as first party (true) or not (false).

        enforce_policies : typing.Optional[bool]
            Whether to enforce authorization policies (true) or to ignore them (false).

        token_encryption : typing.Optional[ResourceServerTokenEncryption]

        consent_policy : typing.Optional[ResourceServerConsentPolicyEnum]

        authorization_details : typing.Optional[typing.Sequence[typing.Any]]

        proof_of_possession : typing.Optional[ResourceServerProofOfPossession]

        subject_type_authorization : typing.Optional[ResourceServerSubjectTypeAuthorization]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateResourceServerResponseContent]
            Resource server successfully created.
        """
        _response = self._client_wrapper.httpx_client.request(
            "resource-servers",
            method="POST",
            json={
                "name": name,
                "identifier": identifier,
                "scopes": convert_and_respect_annotation_metadata(
                    object_=scopes, annotation=typing.Sequence[ResourceServerScope], direction="write"
                ),
                "signing_alg": signing_alg,
                "signing_secret": signing_secret,
                "allow_offline_access": allow_offline_access,
                "token_lifetime": token_lifetime,
                "token_dialect": token_dialect,
                "skip_consent_for_verifiable_first_party_clients": skip_consent_for_verifiable_first_party_clients,
                "enforce_policies": enforce_policies,
                "token_encryption": convert_and_respect_annotation_metadata(
                    object_=token_encryption,
                    annotation=typing.Optional[ResourceServerTokenEncryption],
                    direction="write",
                ),
                "consent_policy": consent_policy,
                "authorization_details": authorization_details,
                "proof_of_possession": convert_and_respect_annotation_metadata(
                    object_=proof_of_possession,
                    annotation=typing.Optional[ResourceServerProofOfPossession],
                    direction="write",
                ),
                "subject_type_authorization": convert_and_respect_annotation_metadata(
                    object_=subject_type_authorization,
                    annotation=ResourceServerSubjectTypeAuthorization,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateResourceServerResponseContent,
                    parse_obj_as(
                        type_=CreateResourceServerResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self,
        id: str,
        *,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetResourceServerResponseContent]:
        """
        Retrieve <a href="https://auth0.com/docs/apis">API</a> details with the given ID.

        Parameters
        ----------
        id : str
            ID or audience of the resource server to retrieve.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetResourceServerResponseContent]
            Resource server successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"resource-servers/{jsonable_encoder(id)}",
            method="GET",
            params={
                "include_fields": include_fields,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetResourceServerResponseContent,
                    parse_obj_as(
                        type_=GetResourceServerResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Delete an existing API by ID. For more information, read <a href="https://www.auth0.com/docs/get-started/apis/api-settings">API Settings</a>.

        Parameters
        ----------
        id : str
            ID or the audience of the resource server to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"resource-servers/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        scopes: typing.Optional[typing.Sequence[ResourceServerScope]] = OMIT,
        signing_alg: typing.Optional[SigningAlgorithmEnum] = OMIT,
        signing_secret: typing.Optional[str] = OMIT,
        skip_consent_for_verifiable_first_party_clients: typing.Optional[bool] = OMIT,
        allow_offline_access: typing.Optional[bool] = OMIT,
        token_lifetime: typing.Optional[int] = OMIT,
        token_dialect: typing.Optional[ResourceServerTokenDialectSchemaEnum] = OMIT,
        enforce_policies: typing.Optional[bool] = OMIT,
        token_encryption: typing.Optional[ResourceServerTokenEncryption] = OMIT,
        consent_policy: typing.Optional[ResourceServerConsentPolicyEnum] = OMIT,
        authorization_details: typing.Optional[typing.Sequence[typing.Any]] = OMIT,
        proof_of_possession: typing.Optional[ResourceServerProofOfPossession] = OMIT,
        subject_type_authorization: typing.Optional[ResourceServerSubjectTypeAuthorization] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateResourceServerResponseContent]:
        """
        Change an existing API setting by resource server ID. For more information, read <a href="https://www.auth0.com/docs/get-started/apis/api-settings">API Settings</a>.

        Parameters
        ----------
        id : str
            ID or audience of the resource server to update.

        name : typing.Optional[str]
            Friendly name for this resource server. Can not contain `<` or `>` characters.

        scopes : typing.Optional[typing.Sequence[ResourceServerScope]]
            List of permissions (scopes) that this API uses.

        signing_alg : typing.Optional[SigningAlgorithmEnum]

        signing_secret : typing.Optional[str]
            Secret used to sign tokens when using symmetric algorithms (HS256).

        skip_consent_for_verifiable_first_party_clients : typing.Optional[bool]
            Whether to skip user consent for applications flagged as first party (true) or not (false).

        allow_offline_access : typing.Optional[bool]
            Whether refresh tokens can be issued for this API (true) or not (false).

        token_lifetime : typing.Optional[int]
            Expiration value (in seconds) for access tokens issued for this API from the token endpoint.

        token_dialect : typing.Optional[ResourceServerTokenDialectSchemaEnum]

        enforce_policies : typing.Optional[bool]
            Whether authorization policies are enforced (true) or not enforced (false).

        token_encryption : typing.Optional[ResourceServerTokenEncryption]

        consent_policy : typing.Optional[ResourceServerConsentPolicyEnum]

        authorization_details : typing.Optional[typing.Sequence[typing.Any]]

        proof_of_possession : typing.Optional[ResourceServerProofOfPossession]

        subject_type_authorization : typing.Optional[ResourceServerSubjectTypeAuthorization]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateResourceServerResponseContent]
            Resource server successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"resource-servers/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
                "scopes": convert_and_respect_annotation_metadata(
                    object_=scopes, annotation=typing.Sequence[ResourceServerScope], direction="write"
                ),
                "signing_alg": signing_alg,
                "signing_secret": signing_secret,
                "skip_consent_for_verifiable_first_party_clients": skip_consent_for_verifiable_first_party_clients,
                "allow_offline_access": allow_offline_access,
                "token_lifetime": token_lifetime,
                "token_dialect": token_dialect,
                "enforce_policies": enforce_policies,
                "token_encryption": convert_and_respect_annotation_metadata(
                    object_=token_encryption,
                    annotation=typing.Optional[ResourceServerTokenEncryption],
                    direction="write",
                ),
                "consent_policy": consent_policy,
                "authorization_details": authorization_details,
                "proof_of_possession": convert_and_respect_annotation_metadata(
                    object_=proof_of_possession,
                    annotation=typing.Optional[ResourceServerProofOfPossession],
                    direction="write",
                ),
                "subject_type_authorization": convert_and_respect_annotation_metadata(
                    object_=subject_type_authorization,
                    annotation=ResourceServerSubjectTypeAuthorization,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateResourceServerResponseContent,
                    parse_obj_as(
                        type_=UpdateResourceServerResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawResourceServersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        identifiers: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ResourceServer, ListResourceServerOffsetPaginatedResponseContent]:
        """
        Retrieve details of all APIs associated with your tenant.

        Parameters
        ----------
        identifiers : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            An optional filter on the resource server identifier. Must be URL encoded and may be specified multiple times (max 10).<br /><b>e.g.</b> <i>../resource-servers?identifiers=id1&identifiers=id2</i>

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ResourceServer, ListResourceServerOffsetPaginatedResponseContent]
            Resource servers successfully retrieved.
        """
        page = page if page is not None else 0

        _response = await self._client_wrapper.httpx_client.request(
            "resource-servers",
            method="GET",
            params={
                "identifiers": identifiers,
                "page": page,
                "per_page": per_page,
                "include_totals": include_totals,
                "include_fields": include_fields,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListResourceServerOffsetPaginatedResponseContent,
                    parse_obj_as(
                        type_=ListResourceServerOffsetPaginatedResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.resource_servers
                _has_next = True

                async def _get_next():
                    return await self.list(
                        identifiers=identifiers,
                        page=page + len(_items or []),
                        per_page=per_page,
                        include_totals=include_totals,
                        include_fields=include_fields,
                        request_options=request_options,
                    )

                return AsyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        identifier: str,
        name: typing.Optional[str] = OMIT,
        scopes: typing.Optional[typing.Sequence[ResourceServerScope]] = OMIT,
        signing_alg: typing.Optional[SigningAlgorithmEnum] = OMIT,
        signing_secret: typing.Optional[str] = OMIT,
        allow_offline_access: typing.Optional[bool] = OMIT,
        token_lifetime: typing.Optional[int] = OMIT,
        token_dialect: typing.Optional[ResourceServerTokenDialectSchemaEnum] = OMIT,
        skip_consent_for_verifiable_first_party_clients: typing.Optional[bool] = OMIT,
        enforce_policies: typing.Optional[bool] = OMIT,
        token_encryption: typing.Optional[ResourceServerTokenEncryption] = OMIT,
        consent_policy: typing.Optional[ResourceServerConsentPolicyEnum] = OMIT,
        authorization_details: typing.Optional[typing.Sequence[typing.Any]] = OMIT,
        proof_of_possession: typing.Optional[ResourceServerProofOfPossession] = OMIT,
        subject_type_authorization: typing.Optional[ResourceServerSubjectTypeAuthorization] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateResourceServerResponseContent]:
        """
        Create a new API associated with your tenant. Note that all new APIs must be registered with Auth0. For more information, read <a href="https://www.auth0.com/docs/get-started/apis"> APIs</a>.

        Parameters
        ----------
        identifier : str
            Unique identifier for the API used as the audience parameter on authorization calls. Can not be changed once set.

        name : typing.Optional[str]
            Friendly name for this resource server. Can not contain `<` or `>` characters.

        scopes : typing.Optional[typing.Sequence[ResourceServerScope]]
            List of permissions (scopes) that this API uses.

        signing_alg : typing.Optional[SigningAlgorithmEnum]

        signing_secret : typing.Optional[str]
            Secret used to sign tokens when using symmetric algorithms (HS256).

        allow_offline_access : typing.Optional[bool]
            Whether refresh tokens can be issued for this API (true) or not (false).

        token_lifetime : typing.Optional[int]
            Expiration value (in seconds) for access tokens issued for this API from the token endpoint.

        token_dialect : typing.Optional[ResourceServerTokenDialectSchemaEnum]

        skip_consent_for_verifiable_first_party_clients : typing.Optional[bool]
            Whether to skip user consent for applications flagged as first party (true) or not (false).

        enforce_policies : typing.Optional[bool]
            Whether to enforce authorization policies (true) or to ignore them (false).

        token_encryption : typing.Optional[ResourceServerTokenEncryption]

        consent_policy : typing.Optional[ResourceServerConsentPolicyEnum]

        authorization_details : typing.Optional[typing.Sequence[typing.Any]]

        proof_of_possession : typing.Optional[ResourceServerProofOfPossession]

        subject_type_authorization : typing.Optional[ResourceServerSubjectTypeAuthorization]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateResourceServerResponseContent]
            Resource server successfully created.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "resource-servers",
            method="POST",
            json={
                "name": name,
                "identifier": identifier,
                "scopes": convert_and_respect_annotation_metadata(
                    object_=scopes, annotation=typing.Sequence[ResourceServerScope], direction="write"
                ),
                "signing_alg": signing_alg,
                "signing_secret": signing_secret,
                "allow_offline_access": allow_offline_access,
                "token_lifetime": token_lifetime,
                "token_dialect": token_dialect,
                "skip_consent_for_verifiable_first_party_clients": skip_consent_for_verifiable_first_party_clients,
                "enforce_policies": enforce_policies,
                "token_encryption": convert_and_respect_annotation_metadata(
                    object_=token_encryption,
                    annotation=typing.Optional[ResourceServerTokenEncryption],
                    direction="write",
                ),
                "consent_policy": consent_policy,
                "authorization_details": authorization_details,
                "proof_of_possession": convert_and_respect_annotation_metadata(
                    object_=proof_of_possession,
                    annotation=typing.Optional[ResourceServerProofOfPossession],
                    direction="write",
                ),
                "subject_type_authorization": convert_and_respect_annotation_metadata(
                    object_=subject_type_authorization,
                    annotation=ResourceServerSubjectTypeAuthorization,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateResourceServerResponseContent,
                    parse_obj_as(
                        type_=CreateResourceServerResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self,
        id: str,
        *,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetResourceServerResponseContent]:
        """
        Retrieve <a href="https://auth0.com/docs/apis">API</a> details with the given ID.

        Parameters
        ----------
        id : str
            ID or audience of the resource server to retrieve.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetResourceServerResponseContent]
            Resource server successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"resource-servers/{jsonable_encoder(id)}",
            method="GET",
            params={
                "include_fields": include_fields,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetResourceServerResponseContent,
                    parse_obj_as(
                        type_=GetResourceServerResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Delete an existing API by ID. For more information, read <a href="https://www.auth0.com/docs/get-started/apis/api-settings">API Settings</a>.

        Parameters
        ----------
        id : str
            ID or the audience of the resource server to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"resource-servers/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        scopes: typing.Optional[typing.Sequence[ResourceServerScope]] = OMIT,
        signing_alg: typing.Optional[SigningAlgorithmEnum] = OMIT,
        signing_secret: typing.Optional[str] = OMIT,
        skip_consent_for_verifiable_first_party_clients: typing.Optional[bool] = OMIT,
        allow_offline_access: typing.Optional[bool] = OMIT,
        token_lifetime: typing.Optional[int] = OMIT,
        token_dialect: typing.Optional[ResourceServerTokenDialectSchemaEnum] = OMIT,
        enforce_policies: typing.Optional[bool] = OMIT,
        token_encryption: typing.Optional[ResourceServerTokenEncryption] = OMIT,
        consent_policy: typing.Optional[ResourceServerConsentPolicyEnum] = OMIT,
        authorization_details: typing.Optional[typing.Sequence[typing.Any]] = OMIT,
        proof_of_possession: typing.Optional[ResourceServerProofOfPossession] = OMIT,
        subject_type_authorization: typing.Optional[ResourceServerSubjectTypeAuthorization] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateResourceServerResponseContent]:
        """
        Change an existing API setting by resource server ID. For more information, read <a href="https://www.auth0.com/docs/get-started/apis/api-settings">API Settings</a>.

        Parameters
        ----------
        id : str
            ID or audience of the resource server to update.

        name : typing.Optional[str]
            Friendly name for this resource server. Can not contain `<` or `>` characters.

        scopes : typing.Optional[typing.Sequence[ResourceServerScope]]
            List of permissions (scopes) that this API uses.

        signing_alg : typing.Optional[SigningAlgorithmEnum]

        signing_secret : typing.Optional[str]
            Secret used to sign tokens when using symmetric algorithms (HS256).

        skip_consent_for_verifiable_first_party_clients : typing.Optional[bool]
            Whether to skip user consent for applications flagged as first party (true) or not (false).

        allow_offline_access : typing.Optional[bool]
            Whether refresh tokens can be issued for this API (true) or not (false).

        token_lifetime : typing.Optional[int]
            Expiration value (in seconds) for access tokens issued for this API from the token endpoint.

        token_dialect : typing.Optional[ResourceServerTokenDialectSchemaEnum]

        enforce_policies : typing.Optional[bool]
            Whether authorization policies are enforced (true) or not enforced (false).

        token_encryption : typing.Optional[ResourceServerTokenEncryption]

        consent_policy : typing.Optional[ResourceServerConsentPolicyEnum]

        authorization_details : typing.Optional[typing.Sequence[typing.Any]]

        proof_of_possession : typing.Optional[ResourceServerProofOfPossession]

        subject_type_authorization : typing.Optional[ResourceServerSubjectTypeAuthorization]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateResourceServerResponseContent]
            Resource server successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"resource-servers/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
                "scopes": convert_and_respect_annotation_metadata(
                    object_=scopes, annotation=typing.Sequence[ResourceServerScope], direction="write"
                ),
                "signing_alg": signing_alg,
                "signing_secret": signing_secret,
                "skip_consent_for_verifiable_first_party_clients": skip_consent_for_verifiable_first_party_clients,
                "allow_offline_access": allow_offline_access,
                "token_lifetime": token_lifetime,
                "token_dialect": token_dialect,
                "enforce_policies": enforce_policies,
                "token_encryption": convert_and_respect_annotation_metadata(
                    object_=token_encryption,
                    annotation=typing.Optional[ResourceServerTokenEncryption],
                    direction="write",
                ),
                "consent_policy": consent_policy,
                "authorization_details": authorization_details,
                "proof_of_possession": convert_and_respect_annotation_metadata(
                    object_=proof_of_possession,
                    annotation=typing.Optional[ResourceServerProofOfPossession],
                    direction="write",
                ),
                "subject_type_authorization": convert_and_respect_annotation_metadata(
                    object_=subject_type_authorization,
                    annotation=ResourceServerSubjectTypeAuthorization,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateResourceServerResponseContent,
                    parse_obj_as(
                        type_=UpdateResourceServerResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
