# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawRiskAssessmentsClient, RawRiskAssessmentsClient

if typing.TYPE_CHECKING:
    from .settings.client import AsyncSettingsClient, SettingsClient


class RiskAssessmentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRiskAssessmentsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._settings: typing.Optional[SettingsClient] = None

    @property
    def with_raw_response(self) -> RawRiskAssessmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRiskAssessmentsClient
        """
        return self._raw_client

    @property
    def settings(self):
        if self._settings is None:
            from .settings.client import SettingsClient  # noqa: E402

            self._settings = SettingsClient(client_wrapper=self._client_wrapper)
        return self._settings


class AsyncRiskAssessmentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRiskAssessmentsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._settings: typing.Optional[AsyncSettingsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawRiskAssessmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRiskAssessmentsClient
        """
        return self._raw_client

    @property
    def settings(self):
        if self._settings is None:
            from .settings.client import AsyncSettingsClient  # noqa: E402

            self._settings = AsyncSettingsClient(client_wrapper=self._client_wrapper)
        return self._settings
