# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.get_risk_assessments_settings_response_content import GetRiskAssessmentsSettingsResponseContent
from ...types.update_risk_assessments_settings_response_content import UpdateRiskAssessmentsSettingsResponseContent
from .raw_client import AsyncRawSettingsClient, RawSettingsClient

if typing.TYPE_CHECKING:
    from .new_device.client import AsyncNewDeviceClient, NewDeviceClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SettingsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSettingsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._new_device: typing.Optional[NewDeviceClient] = None

    @property
    def with_raw_response(self) -> RawSettingsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSettingsClient
        """
        return self._raw_client

    def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetRiskAssessmentsSettingsResponseContent:
        """
        Gets the tenant settings for risk assessments

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetRiskAssessmentsSettingsResponseContent
            Returning risk assessment settings for the tenant

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.risk_assessments.settings.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def update(
        self, *, enabled: bool, request_options: typing.Optional[RequestOptions] = None
    ) -> UpdateRiskAssessmentsSettingsResponseContent:
        """
        Updates the tenant settings for risk assessments

        Parameters
        ----------
        enabled : bool
            Whether or not risk assessment is enabled.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateRiskAssessmentsSettingsResponseContent
            Returning risk assessment settings for the tenant

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.risk_assessments.settings.update(
            enabled=True,
        )
        """
        _response = self._raw_client.update(enabled=enabled, request_options=request_options)
        return _response.data

    @property
    def new_device(self):
        if self._new_device is None:
            from .new_device.client import NewDeviceClient  # noqa: E402

            self._new_device = NewDeviceClient(client_wrapper=self._client_wrapper)
        return self._new_device


class AsyncSettingsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSettingsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._new_device: typing.Optional[AsyncNewDeviceClient] = None

    @property
    def with_raw_response(self) -> AsyncRawSettingsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSettingsClient
        """
        return self._raw_client

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetRiskAssessmentsSettingsResponseContent:
        """
        Gets the tenant settings for risk assessments

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetRiskAssessmentsSettingsResponseContent
            Returning risk assessment settings for the tenant

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.risk_assessments.settings.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def update(
        self, *, enabled: bool, request_options: typing.Optional[RequestOptions] = None
    ) -> UpdateRiskAssessmentsSettingsResponseContent:
        """
        Updates the tenant settings for risk assessments

        Parameters
        ----------
        enabled : bool
            Whether or not risk assessment is enabled.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateRiskAssessmentsSettingsResponseContent
            Returning risk assessment settings for the tenant

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.risk_assessments.settings.update(
                enabled=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(enabled=enabled, request_options=request_options)
        return _response.data

    @property
    def new_device(self):
        if self._new_device is None:
            from .new_device.client import AsyncNewDeviceClient  # noqa: E402

            self._new_device = AsyncNewDeviceClient(client_wrapper=self._client_wrapper)
        return self._new_device
