# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.request_options import RequestOptions
from ....types.get_risk_assessments_settings_new_device_response_content import (
    GetRiskAssessmentsSettingsNewDeviceResponseContent,
)
from ....types.update_risk_assessments_settings_new_device_response_content import (
    UpdateRiskAssessmentsSettingsNewDeviceResponseContent,
)
from .raw_client import AsyncRawNewDeviceClient, RawNewDeviceClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class NewDeviceClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawNewDeviceClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawNewDeviceClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawNewDeviceClient
        """
        return self._raw_client

    def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetRiskAssessmentsSettingsNewDeviceResponseContent:
        """
        Gets the risk assessment settings for the new device assessor

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetRiskAssessmentsSettingsNewDeviceResponseContent
            Returning risk assessment settings for new devices

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.risk_assessments.settings.new_device.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def update(
        self, *, remember_for: int, request_options: typing.Optional[RequestOptions] = None
    ) -> UpdateRiskAssessmentsSettingsNewDeviceResponseContent:
        """
        Updates the risk assessment settings for the new device assessor

        Parameters
        ----------
        remember_for : int
            Length of time to remember devices for, in days.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateRiskAssessmentsSettingsNewDeviceResponseContent
            Returning risk assessment settings for new devices

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.risk_assessments.settings.new_device.update(
            remember_for=1,
        )
        """
        _response = self._raw_client.update(remember_for=remember_for, request_options=request_options)
        return _response.data


class AsyncNewDeviceClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawNewDeviceClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawNewDeviceClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawNewDeviceClient
        """
        return self._raw_client

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetRiskAssessmentsSettingsNewDeviceResponseContent:
        """
        Gets the risk assessment settings for the new device assessor

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetRiskAssessmentsSettingsNewDeviceResponseContent
            Returning risk assessment settings for new devices

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.risk_assessments.settings.new_device.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def update(
        self, *, remember_for: int, request_options: typing.Optional[RequestOptions] = None
    ) -> UpdateRiskAssessmentsSettingsNewDeviceResponseContent:
        """
        Updates the risk assessment settings for the new device assessor

        Parameters
        ----------
        remember_for : int
            Length of time to remember devices for, in days.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateRiskAssessmentsSettingsNewDeviceResponseContent
            Returning risk assessment settings for new devices

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.risk_assessments.settings.new_device.update(
                remember_for=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(remember_for=remember_for, request_options=request_options)
        return _response.data
