# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.list_role_permissions_offset_paginated_response_content import (
    ListRolePermissionsOffsetPaginatedResponseContent,
)
from ...types.permission_request_payload import PermissionRequestPayload
from ...types.permissions_response_payload import PermissionsResponsePayload
from .raw_client import AsyncRawPermissionsClient, RawPermissionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PermissionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPermissionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPermissionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPermissionsClient
        """
        return self._raw_client

    def list(
        self,
        id: str,
        *,
        per_page: typing.Optional[int] = 50,
        page: typing.Optional[int] = 0,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[PermissionsResponsePayload, ListRolePermissionsOffsetPaginatedResponseContent]:
        """
        Retrieve detailed list (name, description, resource server) of permissions granted by a specified user role.

        Parameters
        ----------
        id : str
            ID of the role to list granted permissions.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[PermissionsResponsePayload, ListRolePermissionsOffsetPaginatedResponseContent]
            Role permissions successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.roles.permissions.list(
            id="id",
            per_page=1,
            page=1,
            include_totals=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            id, per_page=per_page, page=page, include_totals=include_totals, request_options=request_options
        )

    def add(
        self,
        id: str,
        *,
        permissions: typing.Sequence[PermissionRequestPayload],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Add one or more <a href="https://auth0.com/docs/manage-users/access-control/configure-core-rbac/manage-permissions">permissions</a> to a specified user role.

        Parameters
        ----------
        id : str
            ID of the role to add permissions to.

        permissions : typing.Sequence[PermissionRequestPayload]
            array of resource_server_identifier, permission_name pairs.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0, PermissionRequestPayload

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.roles.permissions.add(
            id="id",
            permissions=[
                PermissionRequestPayload(
                    resource_server_identifier="resource_server_identifier",
                    permission_name="permission_name",
                )
            ],
        )
        """
        _response = self._raw_client.add(id, permissions=permissions, request_options=request_options)
        return _response.data

    def delete(
        self,
        id: str,
        *,
        permissions: typing.Sequence[PermissionRequestPayload],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Remove one or more <a href="https://auth0.com/docs/manage-users/access-control/configure-core-rbac/manage-permissions">permissions</a> from a specified user role.

        Parameters
        ----------
        id : str
            ID of the role to remove permissions from.

        permissions : typing.Sequence[PermissionRequestPayload]
            array of resource_server_identifier, permission_name pairs.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0, PermissionRequestPayload

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.roles.permissions.delete(
            id="id",
            permissions=[
                PermissionRequestPayload(
                    resource_server_identifier="resource_server_identifier",
                    permission_name="permission_name",
                )
            ],
        )
        """
        _response = self._raw_client.delete(id, permissions=permissions, request_options=request_options)
        return _response.data


class AsyncPermissionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPermissionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPermissionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPermissionsClient
        """
        return self._raw_client

    async def list(
        self,
        id: str,
        *,
        per_page: typing.Optional[int] = 50,
        page: typing.Optional[int] = 0,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[PermissionsResponsePayload, ListRolePermissionsOffsetPaginatedResponseContent]:
        """
        Retrieve detailed list (name, description, resource server) of permissions granted by a specified user role.

        Parameters
        ----------
        id : str
            ID of the role to list granted permissions.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[PermissionsResponsePayload, ListRolePermissionsOffsetPaginatedResponseContent]
            Role permissions successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.roles.permissions.list(
                id="id",
                per_page=1,
                page=1,
                include_totals=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            id, per_page=per_page, page=page, include_totals=include_totals, request_options=request_options
        )

    async def add(
        self,
        id: str,
        *,
        permissions: typing.Sequence[PermissionRequestPayload],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Add one or more <a href="https://auth0.com/docs/manage-users/access-control/configure-core-rbac/manage-permissions">permissions</a> to a specified user role.

        Parameters
        ----------
        id : str
            ID of the role to add permissions to.

        permissions : typing.Sequence[PermissionRequestPayload]
            array of resource_server_identifier, permission_name pairs.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, PermissionRequestPayload

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.roles.permissions.add(
                id="id",
                permissions=[
                    PermissionRequestPayload(
                        resource_server_identifier="resource_server_identifier",
                        permission_name="permission_name",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.add(id, permissions=permissions, request_options=request_options)
        return _response.data

    async def delete(
        self,
        id: str,
        *,
        permissions: typing.Sequence[PermissionRequestPayload],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Remove one or more <a href="https://auth0.com/docs/manage-users/access-control/configure-core-rbac/manage-permissions">permissions</a> from a specified user role.

        Parameters
        ----------
        id : str
            ID of the role to remove permissions from.

        permissions : typing.Sequence[PermissionRequestPayload]
            array of resource_server_identifier, permission_name pairs.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, PermissionRequestPayload

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.roles.permissions.delete(
                id="id",
                permissions=[
                    PermissionRequestPayload(
                        resource_server_identifier="resource_server_identifier",
                        permission_name="permission_name",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, permissions=permissions, request_options=request_options)
        return _response.data
