# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.list_role_users_paginated_response_content import ListRoleUsersPaginatedResponseContent
from ...types.role_user import RoleUser
from .raw_client import AsyncRawUsersClient, RawUsersClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UsersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUsersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUsersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUsersClient
        """
        return self._raw_client

    def list(
        self,
        id: str,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[RoleUser, ListRoleUsersPaginatedResponseContent]:
        """
        Retrieve list of users associated with a specific role. For Dashboard instructions, review <a href="https://auth0.com/docs/manage-users/access-control/configure-core-rbac/roles/view-users-assigned-to-roles">View Users Assigned to Roles</a>.

        This endpoint supports two types of pagination:
        <ul>
        <li>Offset pagination</li>
        <li>Checkpoint pagination</li>
        </ul>

        Checkpoint pagination must be used if you need to retrieve more than 1000 organization members.

        <h2>Checkpoint Pagination</h2>

        To search by checkpoint, use the following parameters:
        <ul>
        <li><code>from</code>: Optional id from which to start selection.</li>
        <li><code>take</code>: The total amount of entries to retrieve when using the from parameter. Defaults to 50.</li>
        </ul>

        <b>Note</b>: The first time you call this endpoint using checkpoint pagination, omit the <code>from</code> parameter. If there are more results, a <code>next</code> value is included in the response. You can use this for subsequent API calls. When <code>next</code> is no longer included in the response, no pages are remaining.

        Parameters
        ----------
        id : str
            ID of the role to retrieve a list of users associated with.

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[RoleUser, ListRoleUsersPaginatedResponseContent]
            Role users successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.roles.users.list(
            id="id",
            from_="from",
            take=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(id, from_=from_, take=take, request_options=request_options)

    def assign(
        self, id: str, *, users: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Assign one or more users to an existing user role. To learn more, review <a href="https://auth0.com/docs/manage-users/access-control/rbac">Role-Based Access Control</a>.

        <b>Note</b>: New roles cannot be created through this action.

        Parameters
        ----------
        id : str
            ID of the role to assign users to.

        users : typing.Sequence[str]
            user_id's of the users to assign the role to.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.roles.users.assign(
            id="id",
            users=["users"],
        )
        """
        _response = self._raw_client.assign(id, users=users, request_options=request_options)
        return _response.data


class AsyncUsersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUsersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUsersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUsersClient
        """
        return self._raw_client

    async def list(
        self,
        id: str,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[RoleUser, ListRoleUsersPaginatedResponseContent]:
        """
        Retrieve list of users associated with a specific role. For Dashboard instructions, review <a href="https://auth0.com/docs/manage-users/access-control/configure-core-rbac/roles/view-users-assigned-to-roles">View Users Assigned to Roles</a>.

        This endpoint supports two types of pagination:
        <ul>
        <li>Offset pagination</li>
        <li>Checkpoint pagination</li>
        </ul>

        Checkpoint pagination must be used if you need to retrieve more than 1000 organization members.

        <h2>Checkpoint Pagination</h2>

        To search by checkpoint, use the following parameters:
        <ul>
        <li><code>from</code>: Optional id from which to start selection.</li>
        <li><code>take</code>: The total amount of entries to retrieve when using the from parameter. Defaults to 50.</li>
        </ul>

        <b>Note</b>: The first time you call this endpoint using checkpoint pagination, omit the <code>from</code> parameter. If there are more results, a <code>next</code> value is included in the response. You can use this for subsequent API calls. When <code>next</code> is no longer included in the response, no pages are remaining.

        Parameters
        ----------
        id : str
            ID of the role to retrieve a list of users associated with.

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[RoleUser, ListRoleUsersPaginatedResponseContent]
            Role users successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.roles.users.list(
                id="id",
                from_="from",
                take=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(id, from_=from_, take=take, request_options=request_options)

    async def assign(
        self, id: str, *, users: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Assign one or more users to an existing user role. To learn more, review <a href="https://auth0.com/docs/manage-users/access-control/rbac">Role-Based Access Control</a>.

        <b>Note</b>: New roles cannot be created through this action.

        Parameters
        ----------
        id : str
            ID of the role to assign users to.

        users : typing.Sequence[str]
            user_id's of the users to assign the role to.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.roles.users.assign(
                id="id",
                users=["users"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.assign(id, users=users, request_options=request_options)
        return _response.data
