# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.create_rule_response_content import CreateRuleResponseContent
from ..types.get_rule_response_content import GetRuleResponseContent
from ..types.list_rules_offset_paginated_response_content import ListRulesOffsetPaginatedResponseContent
from ..types.rule import Rule
from ..types.update_rule_response_content import UpdateRuleResponseContent
from .raw_client import AsyncRawRulesClient, RawRulesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RulesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRulesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRulesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRulesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        enabled: typing.Optional[bool] = None,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Rule, ListRulesOffsetPaginatedResponseContent]:
        """
        Retrieve a filtered list of <a href="https://auth0.com/docs/rules">rules</a>. Accepts a list of fields to include or exclude.

        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        enabled : typing.Optional[bool]
            Optional filter on whether a rule is enabled (true) or disabled (false).

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Rule, ListRulesOffsetPaginatedResponseContent]
            Rules successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.rules.list(
            page=1,
            per_page=1,
            include_totals=True,
            enabled=True,
            fields="fields",
            include_fields=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            enabled=enabled,
            fields=fields,
            include_fields=include_fields,
            request_options=request_options,
        )

    def create(
        self,
        *,
        name: str = "my-rule",
        script: str = "function (user, context, callback) {\n  callback(null, user, context);\n}",
        order: typing.Optional[float] = 2.0,
        enabled: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateRuleResponseContent:
        """
        Create a <a href="https://auth0.com/docs/rules#create-a-new-rule-using-the-management-api">new rule</a>.

        Note: Changing a rule's stage of execution from the default <code>login_success</code> can change the rule's function signature to have user omitted.

        Parameters
        ----------
        name : str
            Name of this rule.

        script : str
            Code to be executed when this rule runs.

        order : typing.Optional[float]
            Order that this rule should execute in relative to other rules. Lower-valued rules execute first.

        enabled : typing.Optional[bool]
            Whether the rule is enabled (true), or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateRuleResponseContent
            Rule successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.rules.create(
            name="name",
            script="script",
        )
        """
        _response = self._raw_client.create(
            name=name, script=script, order=order, enabled=enabled, request_options=request_options
        )
        return _response.data

    def get(
        self,
        id: str,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetRuleResponseContent:
        """
        Retrieve <a href="https://auth0.com/docs/rules">rule</a> details. Accepts a list of fields to include or exclude in the result.

        Parameters
        ----------
        id : str
            ID of the rule to retrieve.

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetRuleResponseContent
            Rule successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.rules.get(
            id="id",
            fields="fields",
            include_fields=True,
        )
        """
        _response = self._raw_client.get(
            id, fields=fields, include_fields=include_fields, request_options=request_options
        )
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a rule.

        Parameters
        ----------
        id : str
            ID of the rule to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.rules.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        script: typing.Optional[str] = "function (user, context, callback) {\n  callback(null, user, context);\n}",
        name: typing.Optional[str] = "my-rule",
        order: typing.Optional[float] = 2.0,
        enabled: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateRuleResponseContent:
        """
        Update an existing rule.

        Parameters
        ----------
        id : str
            ID of the rule to retrieve.

        script : typing.Optional[str]
            Code to be executed when this rule runs.

        name : typing.Optional[str]
            Name of this rule.

        order : typing.Optional[float]
            Order that this rule should execute in relative to other rules. Lower-valued rules execute first.

        enabled : typing.Optional[bool]
            Whether the rule is enabled (true), or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateRuleResponseContent
            Rule successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.rules.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id, script=script, name=name, order=order, enabled=enabled, request_options=request_options
        )
        return _response.data


class AsyncRulesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRulesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRulesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRulesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        enabled: typing.Optional[bool] = None,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Rule, ListRulesOffsetPaginatedResponseContent]:
        """
        Retrieve a filtered list of <a href="https://auth0.com/docs/rules">rules</a>. Accepts a list of fields to include or exclude.

        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        enabled : typing.Optional[bool]
            Optional filter on whether a rule is enabled (true) or disabled (false).

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Rule, ListRulesOffsetPaginatedResponseContent]
            Rules successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.rules.list(
                page=1,
                per_page=1,
                include_totals=True,
                enabled=True,
                fields="fields",
                include_fields=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            enabled=enabled,
            fields=fields,
            include_fields=include_fields,
            request_options=request_options,
        )

    async def create(
        self,
        *,
        name: str = "my-rule",
        script: str = "function (user, context, callback) {\n  callback(null, user, context);\n}",
        order: typing.Optional[float] = 2.0,
        enabled: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateRuleResponseContent:
        """
        Create a <a href="https://auth0.com/docs/rules#create-a-new-rule-using-the-management-api">new rule</a>.

        Note: Changing a rule's stage of execution from the default <code>login_success</code> can change the rule's function signature to have user omitted.

        Parameters
        ----------
        name : str
            Name of this rule.

        script : str
            Code to be executed when this rule runs.

        order : typing.Optional[float]
            Order that this rule should execute in relative to other rules. Lower-valued rules execute first.

        enabled : typing.Optional[bool]
            Whether the rule is enabled (true), or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateRuleResponseContent
            Rule successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.rules.create(
                name="name",
                script="script",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name, script=script, order=order, enabled=enabled, request_options=request_options
        )
        return _response.data

    async def get(
        self,
        id: str,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetRuleResponseContent:
        """
        Retrieve <a href="https://auth0.com/docs/rules">rule</a> details. Accepts a list of fields to include or exclude in the result.

        Parameters
        ----------
        id : str
            ID of the rule to retrieve.

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetRuleResponseContent
            Rule successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.rules.get(
                id="id",
                fields="fields",
                include_fields=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            id, fields=fields, include_fields=include_fields, request_options=request_options
        )
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a rule.

        Parameters
        ----------
        id : str
            ID of the rule to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.rules.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        script: typing.Optional[str] = "function (user, context, callback) {\n  callback(null, user, context);\n}",
        name: typing.Optional[str] = "my-rule",
        order: typing.Optional[float] = 2.0,
        enabled: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateRuleResponseContent:
        """
        Update an existing rule.

        Parameters
        ----------
        id : str
            ID of the rule to retrieve.

        script : typing.Optional[str]
            Code to be executed when this rule runs.

        name : typing.Optional[str]
            Name of this rule.

        order : typing.Optional[float]
            Order that this rule should execute in relative to other rules. Lower-valued rules execute first.

        enabled : typing.Optional[bool]
            Whether the rule is enabled (true), or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateRuleResponseContent
            Rule successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.rules.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id, script=script, name=name, order=order, enabled=enabled, request_options=request_options
        )
        return _response.data
