# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.rules_config import RulesConfig
from ..types.set_rules_config_response_content import SetRulesConfigResponseContent
from .raw_client import AsyncRawRulesConfigsClient, RawRulesConfigsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RulesConfigsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRulesConfigsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRulesConfigsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRulesConfigsClient
        """
        return self._raw_client

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[RulesConfig]:
        """
        Retrieve rules config variable keys.

            Note: For security, config variable values cannot be retrieved outside rule execution.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[RulesConfig]
            Rules config keys successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.rules_configs.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def set(
        self, key: str, *, value: str = "MY_RULES_CONFIG_VALUE", request_options: typing.Optional[RequestOptions] = None
    ) -> SetRulesConfigResponseContent:
        """
        Sets a rules config variable.

        Parameters
        ----------
        key : str
            Key of the rules config variable to set (max length: 127 characters).

        value : str
            Value for a rules config variable.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetRulesConfigResponseContent
            Rules config variable successfully set.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.rules_configs.set(
            key="key",
            value="value",
        )
        """
        _response = self._raw_client.set(key, value=value, request_options=request_options)
        return _response.data

    def delete(self, key: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a rules config variable identified by its key.

        Parameters
        ----------
        key : str
            Key of the rules config variable to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.rules_configs.delete(
            key="key",
        )
        """
        _response = self._raw_client.delete(key, request_options=request_options)
        return _response.data


class AsyncRulesConfigsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRulesConfigsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRulesConfigsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRulesConfigsClient
        """
        return self._raw_client

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[RulesConfig]:
        """
        Retrieve rules config variable keys.

            Note: For security, config variable values cannot be retrieved outside rule execution.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[RulesConfig]
            Rules config keys successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.rules_configs.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def set(
        self, key: str, *, value: str = "MY_RULES_CONFIG_VALUE", request_options: typing.Optional[RequestOptions] = None
    ) -> SetRulesConfigResponseContent:
        """
        Sets a rules config variable.

        Parameters
        ----------
        key : str
            Key of the rules config variable to set (max length: 127 characters).

        value : str
            Value for a rules config variable.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetRulesConfigResponseContent
            Rules config variable successfully set.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.rules_configs.set(
                key="key",
                value="value",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set(key, value=value, request_options=request_options)
        return _response.data

    async def delete(self, key: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a rules config variable identified by its key.

        Parameters
        ----------
        key : str
            Key of the rules config variable to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.rules_configs.delete(
                key="key",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(key, request_options=request_options)
        return _response.data
