# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.create_self_service_profile_response_content import CreateSelfServiceProfileResponseContent
from ..types.get_self_service_profile_response_content import GetSelfServiceProfileResponseContent
from ..types.list_self_service_profiles_paginated_response_content import (
    ListSelfServiceProfilesPaginatedResponseContent,
)
from ..types.self_service_profile import SelfServiceProfile
from ..types.self_service_profile_allowed_strategy_enum import SelfServiceProfileAllowedStrategyEnum
from ..types.self_service_profile_branding import SelfServiceProfileBranding
from ..types.self_service_profile_branding_properties import SelfServiceProfileBrandingProperties
from ..types.self_service_profile_description import SelfServiceProfileDescription
from ..types.self_service_profile_user_attribute import SelfServiceProfileUserAttribute
from ..types.self_service_profile_user_attributes import SelfServiceProfileUserAttributes
from ..types.update_self_service_profile_response_content import UpdateSelfServiceProfileResponseContent
from .raw_client import AsyncRawSelfServiceProfilesClient, RawSelfServiceProfilesClient

if typing.TYPE_CHECKING:
    from .custom_text.client import AsyncCustomTextClient, CustomTextClient
    from .sso_ticket.client import AsyncSsoTicketClient, SsoTicketClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SelfServiceProfilesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSelfServiceProfilesClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._custom_text: typing.Optional[CustomTextClient] = None
        self._sso_ticket: typing.Optional[SsoTicketClient] = None

    @property
    def with_raw_response(self) -> RawSelfServiceProfilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSelfServiceProfilesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[SelfServiceProfile, ListSelfServiceProfilesPaginatedResponseContent]:
        """
        Retrieves self-service profiles.

        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[SelfServiceProfile, ListSelfServiceProfilesPaginatedResponseContent]
            List of existing profiles.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.self_service_profiles.list(
            page=1,
            per_page=1,
            include_totals=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            page=page, per_page=per_page, include_totals=include_totals, request_options=request_options
        )

    def create(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        branding: typing.Optional[SelfServiceProfileBrandingProperties] = OMIT,
        allowed_strategies: typing.Optional[typing.Sequence[SelfServiceProfileAllowedStrategyEnum]] = OMIT,
        user_attributes: typing.Optional[typing.Sequence[SelfServiceProfileUserAttribute]] = OMIT,
        user_attribute_profile_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateSelfServiceProfileResponseContent:
        """
        Creates a self-service profile.

        Parameters
        ----------
        name : str
            The name of the self-service Profile.

        description : typing.Optional[str]
            The description of the self-service Profile.

        branding : typing.Optional[SelfServiceProfileBrandingProperties]

        allowed_strategies : typing.Optional[typing.Sequence[SelfServiceProfileAllowedStrategyEnum]]
            List of IdP strategies that will be shown to users during the Self-Service SSO flow. Possible values: [`oidc`, `samlp`, `waad`, `google-apps`, `adfs`, `okta`, `keycloak-samlp`, `pingfederate`]

        user_attributes : typing.Optional[typing.Sequence[SelfServiceProfileUserAttribute]]
            List of attributes to be mapped that will be shown to the user during the SS-SSO flow.

        user_attribute_profile_id : typing.Optional[str]
            ID of the user-attribute-profile to associate with this self-service profile.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateSelfServiceProfileResponseContent
            Self-service profile successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.self_service_profiles.create(
            name="name",
        )
        """
        _response = self._raw_client.create(
            name=name,
            description=description,
            branding=branding,
            allowed_strategies=allowed_strategies,
            user_attributes=user_attributes,
            user_attribute_profile_id=user_attribute_profile_id,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetSelfServiceProfileResponseContent:
        """
        Retrieves a self-service profile by Id.

        Parameters
        ----------
        id : str
            The id of the self-service profile to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSelfServiceProfileResponseContent
            Record for existing self-service profile.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.self_service_profiles.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Deletes a self-service profile by Id.

        Parameters
        ----------
        id : str
            The id of the self-service profile to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.self_service_profiles.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[SelfServiceProfileDescription] = OMIT,
        branding: typing.Optional[SelfServiceProfileBranding] = OMIT,
        allowed_strategies: typing.Optional[typing.Sequence[SelfServiceProfileAllowedStrategyEnum]] = OMIT,
        user_attributes: typing.Optional[SelfServiceProfileUserAttributes] = OMIT,
        user_attribute_profile_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateSelfServiceProfileResponseContent:
        """
        Updates a self-service profile.

        Parameters
        ----------
        id : str
            The id of the self-service profile to update

        name : typing.Optional[str]
            The name of the self-service Profile.

        description : typing.Optional[SelfServiceProfileDescription]

        branding : typing.Optional[SelfServiceProfileBranding]

        allowed_strategies : typing.Optional[typing.Sequence[SelfServiceProfileAllowedStrategyEnum]]
            List of IdP strategies that will be shown to users during the Self-Service SSO flow. Possible values: [`oidc`, `samlp`, `waad`, `google-apps`, `adfs`, `okta`, `keycloak-samlp`, `pingfederate`]

        user_attributes : typing.Optional[SelfServiceProfileUserAttributes]

        user_attribute_profile_id : typing.Optional[str]
            ID of the user-attribute-profile to associate with this self-service profile.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateSelfServiceProfileResponseContent
            Self-service profile successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.self_service_profiles.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            name=name,
            description=description,
            branding=branding,
            allowed_strategies=allowed_strategies,
            user_attributes=user_attributes,
            user_attribute_profile_id=user_attribute_profile_id,
            request_options=request_options,
        )
        return _response.data

    @property
    def custom_text(self):
        if self._custom_text is None:
            from .custom_text.client import CustomTextClient  # noqa: E402

            self._custom_text = CustomTextClient(client_wrapper=self._client_wrapper)
        return self._custom_text

    @property
    def sso_ticket(self):
        if self._sso_ticket is None:
            from .sso_ticket.client import SsoTicketClient  # noqa: E402

            self._sso_ticket = SsoTicketClient(client_wrapper=self._client_wrapper)
        return self._sso_ticket


class AsyncSelfServiceProfilesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSelfServiceProfilesClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._custom_text: typing.Optional[AsyncCustomTextClient] = None
        self._sso_ticket: typing.Optional[AsyncSsoTicketClient] = None

    @property
    def with_raw_response(self) -> AsyncRawSelfServiceProfilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSelfServiceProfilesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[SelfServiceProfile, ListSelfServiceProfilesPaginatedResponseContent]:
        """
        Retrieves self-service profiles.

        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[SelfServiceProfile, ListSelfServiceProfilesPaginatedResponseContent]
            List of existing profiles.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.self_service_profiles.list(
                page=1,
                per_page=1,
                include_totals=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            page=page, per_page=per_page, include_totals=include_totals, request_options=request_options
        )

    async def create(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        branding: typing.Optional[SelfServiceProfileBrandingProperties] = OMIT,
        allowed_strategies: typing.Optional[typing.Sequence[SelfServiceProfileAllowedStrategyEnum]] = OMIT,
        user_attributes: typing.Optional[typing.Sequence[SelfServiceProfileUserAttribute]] = OMIT,
        user_attribute_profile_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateSelfServiceProfileResponseContent:
        """
        Creates a self-service profile.

        Parameters
        ----------
        name : str
            The name of the self-service Profile.

        description : typing.Optional[str]
            The description of the self-service Profile.

        branding : typing.Optional[SelfServiceProfileBrandingProperties]

        allowed_strategies : typing.Optional[typing.Sequence[SelfServiceProfileAllowedStrategyEnum]]
            List of IdP strategies that will be shown to users during the Self-Service SSO flow. Possible values: [`oidc`, `samlp`, `waad`, `google-apps`, `adfs`, `okta`, `keycloak-samlp`, `pingfederate`]

        user_attributes : typing.Optional[typing.Sequence[SelfServiceProfileUserAttribute]]
            List of attributes to be mapped that will be shown to the user during the SS-SSO flow.

        user_attribute_profile_id : typing.Optional[str]
            ID of the user-attribute-profile to associate with this self-service profile.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateSelfServiceProfileResponseContent
            Self-service profile successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.self_service_profiles.create(
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            description=description,
            branding=branding,
            allowed_strategies=allowed_strategies,
            user_attributes=user_attributes,
            user_attribute_profile_id=user_attribute_profile_id,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetSelfServiceProfileResponseContent:
        """
        Retrieves a self-service profile by Id.

        Parameters
        ----------
        id : str
            The id of the self-service profile to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSelfServiceProfileResponseContent
            Record for existing self-service profile.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.self_service_profiles.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Deletes a self-service profile by Id.

        Parameters
        ----------
        id : str
            The id of the self-service profile to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.self_service_profiles.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[SelfServiceProfileDescription] = OMIT,
        branding: typing.Optional[SelfServiceProfileBranding] = OMIT,
        allowed_strategies: typing.Optional[typing.Sequence[SelfServiceProfileAllowedStrategyEnum]] = OMIT,
        user_attributes: typing.Optional[SelfServiceProfileUserAttributes] = OMIT,
        user_attribute_profile_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateSelfServiceProfileResponseContent:
        """
        Updates a self-service profile.

        Parameters
        ----------
        id : str
            The id of the self-service profile to update

        name : typing.Optional[str]
            The name of the self-service Profile.

        description : typing.Optional[SelfServiceProfileDescription]

        branding : typing.Optional[SelfServiceProfileBranding]

        allowed_strategies : typing.Optional[typing.Sequence[SelfServiceProfileAllowedStrategyEnum]]
            List of IdP strategies that will be shown to users during the Self-Service SSO flow. Possible values: [`oidc`, `samlp`, `waad`, `google-apps`, `adfs`, `okta`, `keycloak-samlp`, `pingfederate`]

        user_attributes : typing.Optional[SelfServiceProfileUserAttributes]

        user_attribute_profile_id : typing.Optional[str]
            ID of the user-attribute-profile to associate with this self-service profile.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateSelfServiceProfileResponseContent
            Self-service profile successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.self_service_profiles.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            name=name,
            description=description,
            branding=branding,
            allowed_strategies=allowed_strategies,
            user_attributes=user_attributes,
            user_attribute_profile_id=user_attribute_profile_id,
            request_options=request_options,
        )
        return _response.data

    @property
    def custom_text(self):
        if self._custom_text is None:
            from .custom_text.client import AsyncCustomTextClient  # noqa: E402

            self._custom_text = AsyncCustomTextClient(client_wrapper=self._client_wrapper)
        return self._custom_text

    @property
    def sso_ticket(self):
        if self._sso_ticket is None:
            from .sso_ticket.client import AsyncSsoTicketClient  # noqa: E402

            self._sso_ticket = AsyncSsoTicketClient(client_wrapper=self._client_wrapper)
        return self._sso_ticket
