# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.list_self_service_profile_custom_text_response_content import (
    ListSelfServiceProfileCustomTextResponseContent,
)
from ...types.set_self_service_profile_custom_text_request_content import SetSelfServiceProfileCustomTextRequestContent
from ...types.set_self_service_profile_custom_text_response_content import (
    SetSelfServiceProfileCustomTextResponseContent,
)
from .raw_client import AsyncRawCustomTextClient, RawCustomTextClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CustomTextClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCustomTextClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCustomTextClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCustomTextClient
        """
        return self._raw_client

    def list(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ListSelfServiceProfileCustomTextResponseContent:
        """
        Retrieves text customizations for a given self-service profile, language and Self Service SSO Flow page.

        Parameters
        ----------
        id : str
            The id of the self-service profile.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListSelfServiceProfileCustomTextResponseContent
            Retrieved custom text.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.self_service_profiles.custom_text.list(
            id="id",
        )
        """
        _response = self._raw_client.list(id, request_options=request_options)
        return _response.data

    def set(
        self,
        id: str,
        *,
        request: SetSelfServiceProfileCustomTextRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetSelfServiceProfileCustomTextResponseContent:
        """
        Updates text customizations for a given self-service profile, language and Self Service SSO Flow page.

        Parameters
        ----------
        id : str
            The id of the self-service profile.

        request : SetSelfServiceProfileCustomTextRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetSelfServiceProfileCustomTextResponseContent
            Updated custom text.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.self_service_profiles.custom_text.set(
            id="id",
            request={"key": "value"},
        )
        """
        _response = self._raw_client.set(id, request=request, request_options=request_options)
        return _response.data


class AsyncCustomTextClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCustomTextClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCustomTextClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCustomTextClient
        """
        return self._raw_client

    async def list(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ListSelfServiceProfileCustomTextResponseContent:
        """
        Retrieves text customizations for a given self-service profile, language and Self Service SSO Flow page.

        Parameters
        ----------
        id : str
            The id of the self-service profile.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListSelfServiceProfileCustomTextResponseContent
            Retrieved custom text.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.self_service_profiles.custom_text.list(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(id, request_options=request_options)
        return _response.data

    async def set(
        self,
        id: str,
        *,
        request: SetSelfServiceProfileCustomTextRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetSelfServiceProfileCustomTextResponseContent:
        """
        Updates text customizations for a given self-service profile, language and Self Service SSO Flow page.

        Parameters
        ----------
        id : str
            The id of the self-service profile.

        request : SetSelfServiceProfileCustomTextRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetSelfServiceProfileCustomTextResponseContent
            Updated custom text.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.self_service_profiles.custom_text.set(
                id="id",
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set(id, request=request, request_options=request_options)
        return _response.data
