# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.create_self_service_profile_sso_ticket_response_content import (
    CreateSelfServiceProfileSsoTicketResponseContent,
)
from ...types.self_service_profile_sso_ticket_connection_config import SelfServiceProfileSsoTicketConnectionConfig
from ...types.self_service_profile_sso_ticket_domain_aliases_config import (
    SelfServiceProfileSsoTicketDomainAliasesConfig,
)
from ...types.self_service_profile_sso_ticket_enabled_organization import SelfServiceProfileSsoTicketEnabledOrganization
from ...types.self_service_profile_sso_ticket_provisioning_config import SelfServiceProfileSsoTicketProvisioningConfig
from .raw_client import AsyncRawSsoTicketClient, RawSsoTicketClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SsoTicketClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSsoTicketClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSsoTicketClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSsoTicketClient
        """
        return self._raw_client

    def create(
        self,
        id: str,
        *,
        connection_id: typing.Optional[str] = OMIT,
        connection_config: typing.Optional[SelfServiceProfileSsoTicketConnectionConfig] = OMIT,
        enabled_clients: typing.Optional[typing.Sequence[str]] = OMIT,
        enabled_organizations: typing.Optional[typing.Sequence[SelfServiceProfileSsoTicketEnabledOrganization]] = OMIT,
        ttl_sec: typing.Optional[int] = OMIT,
        domain_aliases_config: typing.Optional[SelfServiceProfileSsoTicketDomainAliasesConfig] = OMIT,
        provisioning_config: typing.Optional[SelfServiceProfileSsoTicketProvisioningConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateSelfServiceProfileSsoTicketResponseContent:
        """
        Creates an SSO access ticket to initiate the Self Service SSO Flow using a self-service profile.

        Parameters
        ----------
        id : str
            The id of the self-service profile to retrieve

        connection_id : typing.Optional[str]
            If provided, this will allow editing of the provided connection during the SSO Flow

        connection_config : typing.Optional[SelfServiceProfileSsoTicketConnectionConfig]

        enabled_clients : typing.Optional[typing.Sequence[str]]
            List of client_ids that the connection will be enabled for.

        enabled_organizations : typing.Optional[typing.Sequence[SelfServiceProfileSsoTicketEnabledOrganization]]
            List of organizations that the connection will be enabled for.

        ttl_sec : typing.Optional[int]
            Number of seconds for which the ticket is valid before expiration. If unspecified or set to 0, this value defaults to 432000 seconds (5 days).

        domain_aliases_config : typing.Optional[SelfServiceProfileSsoTicketDomainAliasesConfig]

        provisioning_config : typing.Optional[SelfServiceProfileSsoTicketProvisioningConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateSelfServiceProfileSsoTicketResponseContent
            SSO Access Ticket successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.self_service_profiles.sso_ticket.create(
            id="id",
        )
        """
        _response = self._raw_client.create(
            id,
            connection_id=connection_id,
            connection_config=connection_config,
            enabled_clients=enabled_clients,
            enabled_organizations=enabled_organizations,
            ttl_sec=ttl_sec,
            domain_aliases_config=domain_aliases_config,
            provisioning_config=provisioning_config,
            request_options=request_options,
        )
        return _response.data

    def revoke(self, profile_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Revokes an SSO access ticket and invalidates associated sessions. The ticket will no longer be accepted to initiate a Self-Service SSO session. If any users have already started a session through this ticket, their session will be terminated. Clients should expect a `202 Accepted` response upon successful processing, indicating that the request has been acknowledged and that the revocation is underway but may not be fully completed at the time of response. If the specified ticket does not exist, a `202 Accepted` response is also returned, signaling that no further action is required.
        Clients should treat these `202` responses as an acknowledgment that the request has been accepted and is in progress, even if the ticket was not found.

        Parameters
        ----------
        profile_id : str
            The id of the self-service profile

        id : str
            The id of the ticket to revoke

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.self_service_profiles.sso_ticket.revoke(
            profile_id="profileId",
            id="id",
        )
        """
        _response = self._raw_client.revoke(profile_id, id, request_options=request_options)
        return _response.data


class AsyncSsoTicketClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSsoTicketClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSsoTicketClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSsoTicketClient
        """
        return self._raw_client

    async def create(
        self,
        id: str,
        *,
        connection_id: typing.Optional[str] = OMIT,
        connection_config: typing.Optional[SelfServiceProfileSsoTicketConnectionConfig] = OMIT,
        enabled_clients: typing.Optional[typing.Sequence[str]] = OMIT,
        enabled_organizations: typing.Optional[typing.Sequence[SelfServiceProfileSsoTicketEnabledOrganization]] = OMIT,
        ttl_sec: typing.Optional[int] = OMIT,
        domain_aliases_config: typing.Optional[SelfServiceProfileSsoTicketDomainAliasesConfig] = OMIT,
        provisioning_config: typing.Optional[SelfServiceProfileSsoTicketProvisioningConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateSelfServiceProfileSsoTicketResponseContent:
        """
        Creates an SSO access ticket to initiate the Self Service SSO Flow using a self-service profile.

        Parameters
        ----------
        id : str
            The id of the self-service profile to retrieve

        connection_id : typing.Optional[str]
            If provided, this will allow editing of the provided connection during the SSO Flow

        connection_config : typing.Optional[SelfServiceProfileSsoTicketConnectionConfig]

        enabled_clients : typing.Optional[typing.Sequence[str]]
            List of client_ids that the connection will be enabled for.

        enabled_organizations : typing.Optional[typing.Sequence[SelfServiceProfileSsoTicketEnabledOrganization]]
            List of organizations that the connection will be enabled for.

        ttl_sec : typing.Optional[int]
            Number of seconds for which the ticket is valid before expiration. If unspecified or set to 0, this value defaults to 432000 seconds (5 days).

        domain_aliases_config : typing.Optional[SelfServiceProfileSsoTicketDomainAliasesConfig]

        provisioning_config : typing.Optional[SelfServiceProfileSsoTicketProvisioningConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateSelfServiceProfileSsoTicketResponseContent
            SSO Access Ticket successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.self_service_profiles.sso_ticket.create(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            id,
            connection_id=connection_id,
            connection_config=connection_config,
            enabled_clients=enabled_clients,
            enabled_organizations=enabled_organizations,
            ttl_sec=ttl_sec,
            domain_aliases_config=domain_aliases_config,
            provisioning_config=provisioning_config,
            request_options=request_options,
        )
        return _response.data

    async def revoke(
        self, profile_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Revokes an SSO access ticket and invalidates associated sessions. The ticket will no longer be accepted to initiate a Self-Service SSO session. If any users have already started a session through this ticket, their session will be terminated. Clients should expect a `202 Accepted` response upon successful processing, indicating that the request has been acknowledged and that the revocation is underway but may not be fully completed at the time of response. If the specified ticket does not exist, a `202 Accepted` response is also returned, signaling that no further action is required.
        Clients should treat these `202` responses as an acknowledgment that the request has been accepted and is in progress, even if the ticket was not found.

        Parameters
        ----------
        profile_id : str
            The id of the self-service profile

        id : str
            The id of the ticket to revoke

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.self_service_profiles.sso_ticket.revoke(
                profile_id="profileId",
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.revoke(profile_id, id, request_options=request_options)
        return _response.data
