# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.bad_request_error import BadRequestError
from ...errors.forbidden_error import ForbiddenError
from ...errors.too_many_requests_error import TooManyRequestsError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.create_self_service_profile_sso_ticket_response_content import (
    CreateSelfServiceProfileSsoTicketResponseContent,
)
from ...types.self_service_profile_sso_ticket_connection_config import SelfServiceProfileSsoTicketConnectionConfig
from ...types.self_service_profile_sso_ticket_domain_aliases_config import (
    SelfServiceProfileSsoTicketDomainAliasesConfig,
)
from ...types.self_service_profile_sso_ticket_enabled_organization import SelfServiceProfileSsoTicketEnabledOrganization
from ...types.self_service_profile_sso_ticket_provisioning_config import SelfServiceProfileSsoTicketProvisioningConfig

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawSsoTicketClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        id: str,
        *,
        connection_id: typing.Optional[str] = OMIT,
        connection_config: typing.Optional[SelfServiceProfileSsoTicketConnectionConfig] = OMIT,
        enabled_clients: typing.Optional[typing.Sequence[str]] = OMIT,
        enabled_organizations: typing.Optional[typing.Sequence[SelfServiceProfileSsoTicketEnabledOrganization]] = OMIT,
        ttl_sec: typing.Optional[int] = OMIT,
        domain_aliases_config: typing.Optional[SelfServiceProfileSsoTicketDomainAliasesConfig] = OMIT,
        provisioning_config: typing.Optional[SelfServiceProfileSsoTicketProvisioningConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateSelfServiceProfileSsoTicketResponseContent]:
        """
        Creates an SSO access ticket to initiate the Self Service SSO Flow using a self-service profile.

        Parameters
        ----------
        id : str
            The id of the self-service profile to retrieve

        connection_id : typing.Optional[str]
            If provided, this will allow editing of the provided connection during the SSO Flow

        connection_config : typing.Optional[SelfServiceProfileSsoTicketConnectionConfig]

        enabled_clients : typing.Optional[typing.Sequence[str]]
            List of client_ids that the connection will be enabled for.

        enabled_organizations : typing.Optional[typing.Sequence[SelfServiceProfileSsoTicketEnabledOrganization]]
            List of organizations that the connection will be enabled for.

        ttl_sec : typing.Optional[int]
            Number of seconds for which the ticket is valid before expiration. If unspecified or set to 0, this value defaults to 432000 seconds (5 days).

        domain_aliases_config : typing.Optional[SelfServiceProfileSsoTicketDomainAliasesConfig]

        provisioning_config : typing.Optional[SelfServiceProfileSsoTicketProvisioningConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateSelfServiceProfileSsoTicketResponseContent]
            SSO Access Ticket successfully created.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"self-service-profiles/{jsonable_encoder(id)}/sso-ticket",
            method="POST",
            json={
                "connection_id": connection_id,
                "connection_config": convert_and_respect_annotation_metadata(
                    object_=connection_config, annotation=SelfServiceProfileSsoTicketConnectionConfig, direction="write"
                ),
                "enabled_clients": enabled_clients,
                "enabled_organizations": convert_and_respect_annotation_metadata(
                    object_=enabled_organizations,
                    annotation=typing.Sequence[SelfServiceProfileSsoTicketEnabledOrganization],
                    direction="write",
                ),
                "ttl_sec": ttl_sec,
                "domain_aliases_config": convert_and_respect_annotation_metadata(
                    object_=domain_aliases_config,
                    annotation=SelfServiceProfileSsoTicketDomainAliasesConfig,
                    direction="write",
                ),
                "provisioning_config": convert_and_respect_annotation_metadata(
                    object_=provisioning_config,
                    annotation=SelfServiceProfileSsoTicketProvisioningConfig,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateSelfServiceProfileSsoTicketResponseContent,
                    parse_obj_as(
                        type_=CreateSelfServiceProfileSsoTicketResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def revoke(
        self, profile_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Revokes an SSO access ticket and invalidates associated sessions. The ticket will no longer be accepted to initiate a Self-Service SSO session. If any users have already started a session through this ticket, their session will be terminated. Clients should expect a `202 Accepted` response upon successful processing, indicating that the request has been acknowledged and that the revocation is underway but may not be fully completed at the time of response. If the specified ticket does not exist, a `202 Accepted` response is also returned, signaling that no further action is required.
        Clients should treat these `202` responses as an acknowledgment that the request has been accepted and is in progress, even if the ticket was not found.

        Parameters
        ----------
        profile_id : str
            The id of the self-service profile

        id : str
            The id of the ticket to revoke

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"self-service-profiles/{jsonable_encoder(profile_id)}/sso-ticket/{jsonable_encoder(id)}/revoke",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawSsoTicketClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        id: str,
        *,
        connection_id: typing.Optional[str] = OMIT,
        connection_config: typing.Optional[SelfServiceProfileSsoTicketConnectionConfig] = OMIT,
        enabled_clients: typing.Optional[typing.Sequence[str]] = OMIT,
        enabled_organizations: typing.Optional[typing.Sequence[SelfServiceProfileSsoTicketEnabledOrganization]] = OMIT,
        ttl_sec: typing.Optional[int] = OMIT,
        domain_aliases_config: typing.Optional[SelfServiceProfileSsoTicketDomainAliasesConfig] = OMIT,
        provisioning_config: typing.Optional[SelfServiceProfileSsoTicketProvisioningConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateSelfServiceProfileSsoTicketResponseContent]:
        """
        Creates an SSO access ticket to initiate the Self Service SSO Flow using a self-service profile.

        Parameters
        ----------
        id : str
            The id of the self-service profile to retrieve

        connection_id : typing.Optional[str]
            If provided, this will allow editing of the provided connection during the SSO Flow

        connection_config : typing.Optional[SelfServiceProfileSsoTicketConnectionConfig]

        enabled_clients : typing.Optional[typing.Sequence[str]]
            List of client_ids that the connection will be enabled for.

        enabled_organizations : typing.Optional[typing.Sequence[SelfServiceProfileSsoTicketEnabledOrganization]]
            List of organizations that the connection will be enabled for.

        ttl_sec : typing.Optional[int]
            Number of seconds for which the ticket is valid before expiration. If unspecified or set to 0, this value defaults to 432000 seconds (5 days).

        domain_aliases_config : typing.Optional[SelfServiceProfileSsoTicketDomainAliasesConfig]

        provisioning_config : typing.Optional[SelfServiceProfileSsoTicketProvisioningConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateSelfServiceProfileSsoTicketResponseContent]
            SSO Access Ticket successfully created.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"self-service-profiles/{jsonable_encoder(id)}/sso-ticket",
            method="POST",
            json={
                "connection_id": connection_id,
                "connection_config": convert_and_respect_annotation_metadata(
                    object_=connection_config, annotation=SelfServiceProfileSsoTicketConnectionConfig, direction="write"
                ),
                "enabled_clients": enabled_clients,
                "enabled_organizations": convert_and_respect_annotation_metadata(
                    object_=enabled_organizations,
                    annotation=typing.Sequence[SelfServiceProfileSsoTicketEnabledOrganization],
                    direction="write",
                ),
                "ttl_sec": ttl_sec,
                "domain_aliases_config": convert_and_respect_annotation_metadata(
                    object_=domain_aliases_config,
                    annotation=SelfServiceProfileSsoTicketDomainAliasesConfig,
                    direction="write",
                ),
                "provisioning_config": convert_and_respect_annotation_metadata(
                    object_=provisioning_config,
                    annotation=SelfServiceProfileSsoTicketProvisioningConfig,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateSelfServiceProfileSsoTicketResponseContent,
                    parse_obj_as(
                        type_=CreateSelfServiceProfileSsoTicketResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def revoke(
        self, profile_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Revokes an SSO access ticket and invalidates associated sessions. The ticket will no longer be accepted to initiate a Self-Service SSO session. If any users have already started a session through this ticket, their session will be terminated. Clients should expect a `202 Accepted` response upon successful processing, indicating that the request has been acknowledged and that the revocation is underway but may not be fully completed at the time of response. If the specified ticket does not exist, a `202 Accepted` response is also returned, signaling that no further action is required.
        Clients should treat these `202` responses as an acknowledgment that the request has been accepted and is in progress, even if the ticket was not found.

        Parameters
        ----------
        profile_id : str
            The id of the self-service profile

        id : str
            The id of the ticket to revoke

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"self-service-profiles/{jsonable_encoder(profile_id)}/sso-ticket/{jsonable_encoder(id)}/revoke",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
