# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.get_session_response_content import GetSessionResponseContent
from ..types.session_metadata import SessionMetadata
from ..types.update_session_response_content import UpdateSessionResponseContent
from .raw_client import AsyncRawSessionsClient, RawSessionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SessionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSessionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSessionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSessionsClient
        """
        return self._raw_client

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetSessionResponseContent:
        """
        Retrieve session information.

        Parameters
        ----------
        id : str
            ID of session to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSessionResponseContent
            The session was retrieved

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.sessions.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a session by ID.

        Parameters
        ----------
        id : str
            ID of the session to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.sessions.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        session_metadata: typing.Optional[SessionMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateSessionResponseContent:
        """
        Update session information.

        Parameters
        ----------
        id : str
            ID of the session to update.

        session_metadata : typing.Optional[SessionMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateSessionResponseContent
            Session successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.sessions.update(
            id="id",
        )
        """
        _response = self._raw_client.update(id, session_metadata=session_metadata, request_options=request_options)
        return _response.data

    def revoke(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Revokes a session by ID and all associated refresh tokens.

        Parameters
        ----------
        id : str
            ID of the session to revoke.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.sessions.revoke(
            id="id",
        )
        """
        _response = self._raw_client.revoke(id, request_options=request_options)
        return _response.data


class AsyncSessionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSessionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSessionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSessionsClient
        """
        return self._raw_client

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetSessionResponseContent:
        """
        Retrieve session information.

        Parameters
        ----------
        id : str
            ID of session to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSessionResponseContent
            The session was retrieved

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.sessions.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a session by ID.

        Parameters
        ----------
        id : str
            ID of the session to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.sessions.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        session_metadata: typing.Optional[SessionMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateSessionResponseContent:
        """
        Update session information.

        Parameters
        ----------
        id : str
            ID of the session to update.

        session_metadata : typing.Optional[SessionMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateSessionResponseContent
            Session successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.sessions.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id, session_metadata=session_metadata, request_options=request_options
        )
        return _response.data

    async def revoke(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Revokes a session by ID and all associated refresh tokens.

        Parameters
        ----------
        id : str
            ID of the session to revoke.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.sessions.revoke(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.revoke(id, request_options=request_options)
        return _response.data
