# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.daily_stats import DailyStats
from ..types.get_active_users_count_stats_response_content import GetActiveUsersCountStatsResponseContent
from .raw_client import AsyncRawStatsClient, RawStatsClient


class StatsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawStatsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawStatsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawStatsClient
        """
        return self._raw_client

    def get_active_users_count(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetActiveUsersCountStatsResponseContent:
        """
        Retrieve the number of active users that logged in during the last 30 days.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetActiveUsersCountStatsResponseContent
            Number of active users successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.stats.get_active_users_count()
        """
        _response = self._raw_client.get_active_users_count(request_options=request_options)
        return _response.data

    def get_daily(
        self,
        *,
        from_: typing.Optional[str] = None,
        to: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[DailyStats]:
        """
        Retrieve the number of logins, signups and breached-password detections (subscription required) that occurred each day within a specified date range.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional first day of the date range (inclusive) in YYYYMMDD format.

        to : typing.Optional[str]
            Optional last day of the date range (inclusive) in YYYYMMDD format.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[DailyStats]
            Daily stats successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.stats.get_daily(
            from_="from",
            to="to",
        )
        """
        _response = self._raw_client.get_daily(from_=from_, to=to, request_options=request_options)
        return _response.data


class AsyncStatsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawStatsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawStatsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawStatsClient
        """
        return self._raw_client

    async def get_active_users_count(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetActiveUsersCountStatsResponseContent:
        """
        Retrieve the number of active users that logged in during the last 30 days.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetActiveUsersCountStatsResponseContent
            Number of active users successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.stats.get_active_users_count()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_active_users_count(request_options=request_options)
        return _response.data

    async def get_daily(
        self,
        *,
        from_: typing.Optional[str] = None,
        to: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[DailyStats]:
        """
        Retrieve the number of logins, signups and breached-password detections (subscription required) that occurred each day within a specified date range.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional first day of the date range (inclusive) in YYYYMMDD format.

        to : typing.Optional[str]
            Optional last day of the date range (inclusive) in YYYYMMDD format.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[DailyStats]
            Daily stats successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.stats.get_daily(
                from_="from",
                to="to",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_daily(from_=from_, to=to, request_options=request_options)
        return _response.data
