# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.get_supplemental_signals_response_content import GetSupplementalSignalsResponseContent
from ..types.patch_supplemental_signals_response_content import PatchSupplementalSignalsResponseContent
from .raw_client import AsyncRawSupplementalSignalsClient, RawSupplementalSignalsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SupplementalSignalsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSupplementalSignalsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSupplementalSignalsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSupplementalSignalsClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> GetSupplementalSignalsResponseContent:
        """
        Get the supplemental signals configuration for a tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSupplementalSignalsResponseContent
            Supplemental Signals configuration successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.supplemental_signals.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def patch(
        self, *, akamai_enabled: bool, request_options: typing.Optional[RequestOptions] = None
    ) -> PatchSupplementalSignalsResponseContent:
        """
        Update the supplemental signals configuration for a tenant.

        Parameters
        ----------
        akamai_enabled : bool
            Indicates if incoming Akamai Headers should be processed

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatchSupplementalSignalsResponseContent
            Supplemental Signals configuration successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.supplemental_signals.patch(
            akamai_enabled=True,
        )
        """
        _response = self._raw_client.patch(akamai_enabled=akamai_enabled, request_options=request_options)
        return _response.data


class AsyncSupplementalSignalsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSupplementalSignalsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSupplementalSignalsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSupplementalSignalsClient
        """
        return self._raw_client

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetSupplementalSignalsResponseContent:
        """
        Get the supplemental signals configuration for a tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSupplementalSignalsResponseContent
            Supplemental Signals configuration successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.supplemental_signals.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def patch(
        self, *, akamai_enabled: bool, request_options: typing.Optional[RequestOptions] = None
    ) -> PatchSupplementalSignalsResponseContent:
        """
        Update the supplemental signals configuration for a tenant.

        Parameters
        ----------
        akamai_enabled : bool
            Indicates if incoming Akamai Headers should be processed

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatchSupplementalSignalsResponseContent
            Supplemental Signals configuration successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.supplemental_signals.patch(
                akamai_enabled=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.patch(akamai_enabled=akamai_enabled, request_options=request_options)
        return _response.data
