# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.default_token_quota import DefaultTokenQuota
from ...types.get_tenant_settings_response_content import GetTenantSettingsResponseContent
from ...types.session_cookie_schema import SessionCookieSchema
from ...types.tenant_oidc_logout_settings import TenantOidcLogoutSettings
from ...types.tenant_settings_device_flow import TenantSettingsDeviceFlow
from ...types.tenant_settings_error_page import TenantSettingsErrorPage
from ...types.tenant_settings_flags import TenantSettingsFlags
from ...types.tenant_settings_guardian_page import TenantSettingsGuardianPage
from ...types.tenant_settings_mtls import TenantSettingsMtls
from ...types.tenant_settings_password_page import TenantSettingsPasswordPage
from ...types.tenant_settings_resource_parameter_profile import TenantSettingsResourceParameterProfile
from ...types.tenant_settings_sessions import TenantSettingsSessions
from ...types.update_tenant_settings_response_content import UpdateTenantSettingsResponseContent
from .raw_client import AsyncRawSettingsClient, RawSettingsClient
from .types.update_tenant_settings_request_content_enabled_locales_item import (
    UpdateTenantSettingsRequestContentEnabledLocalesItem,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SettingsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSettingsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSettingsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSettingsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetTenantSettingsResponseContent:
        """
        Retrieve tenant settings. A list of fields to include or exclude may also be specified.

        Parameters
        ----------
        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTenantSettingsResponseContent
            Tenant settings successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.tenants.settings.get(
            fields="fields",
            include_fields=True,
        )
        """
        _response = self._raw_client.get(fields=fields, include_fields=include_fields, request_options=request_options)
        return _response.data

    def update(
        self,
        *,
        change_password: typing.Optional[TenantSettingsPasswordPage] = OMIT,
        device_flow: typing.Optional[TenantSettingsDeviceFlow] = OMIT,
        guardian_mfa_page: typing.Optional[TenantSettingsGuardianPage] = OMIT,
        default_audience: typing.Optional[str] = "",
        default_directory: typing.Optional[str] = "",
        error_page: typing.Optional[TenantSettingsErrorPage] = OMIT,
        default_token_quota: typing.Optional[DefaultTokenQuota] = OMIT,
        flags: typing.Optional[TenantSettingsFlags] = OMIT,
        friendly_name: typing.Optional[str] = "My Company",
        picture_url: typing.Optional[str] = "https://mycompany.org/logo.png",
        support_email: typing.Optional[str] = "support@mycompany.org",
        support_url: typing.Optional[str] = "https://mycompany.org/support",
        allowed_logout_urls: typing.Optional[typing.Sequence[str]] = OMIT,
        session_lifetime: typing.Optional[int] = 168,
        idle_session_lifetime: typing.Optional[int] = 72,
        ephemeral_session_lifetime: typing.Optional[int] = 72,
        idle_ephemeral_session_lifetime: typing.Optional[int] = 24,
        sandbox_version: typing.Optional[str] = "22",
        legacy_sandbox_version: typing.Optional[str] = OMIT,
        default_redirection_uri: typing.Optional[str] = OMIT,
        enabled_locales: typing.Optional[typing.Sequence[UpdateTenantSettingsRequestContentEnabledLocalesItem]] = OMIT,
        session_cookie: typing.Optional[SessionCookieSchema] = OMIT,
        sessions: typing.Optional[TenantSettingsSessions] = OMIT,
        oidc_logout: typing.Optional[TenantOidcLogoutSettings] = OMIT,
        customize_mfa_in_postlogin_action: typing.Optional[bool] = False,
        allow_organization_name_in_authentication_api: typing.Optional[bool] = False,
        acr_values_supported: typing.Optional[typing.Sequence[str]] = OMIT,
        mtls: typing.Optional[TenantSettingsMtls] = OMIT,
        pushed_authorization_requests_supported: typing.Optional[bool] = False,
        authorization_response_iss_parameter_supported: typing.Optional[bool] = False,
        skip_non_verifiable_callback_uri_confirmation_prompt: typing.Optional[bool] = OMIT,
        resource_parameter_profile: typing.Optional[TenantSettingsResourceParameterProfile] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateTenantSettingsResponseContent:
        """
        Update settings for a tenant.

        Parameters
        ----------
        change_password : typing.Optional[TenantSettingsPasswordPage]

        device_flow : typing.Optional[TenantSettingsDeviceFlow]

        guardian_mfa_page : typing.Optional[TenantSettingsGuardianPage]

        default_audience : typing.Optional[str]
            Default audience for API Authorization.

        default_directory : typing.Optional[str]
            Name of connection used for password grants at the `/token` endpoint. The following connection types are supported: LDAP, AD, Database Connections, Passwordless, Windows Azure Active Directory, ADFS.

        error_page : typing.Optional[TenantSettingsErrorPage]

        default_token_quota : typing.Optional[DefaultTokenQuota]

        flags : typing.Optional[TenantSettingsFlags]

        friendly_name : typing.Optional[str]
            Friendly name for this tenant.

        picture_url : typing.Optional[str]
            URL of logo to be shown for this tenant (recommended size: 150x150)

        support_email : typing.Optional[str]
            End-user support email.

        support_url : typing.Optional[str]
            End-user support url.

        allowed_logout_urls : typing.Optional[typing.Sequence[str]]
            URLs that are valid to redirect to after logout from Auth0.

        session_lifetime : typing.Optional[int]
            Number of hours a session will stay valid.

        idle_session_lifetime : typing.Optional[int]
            Number of hours for which a session can be inactive before the user must log in again.

        ephemeral_session_lifetime : typing.Optional[int]
            Number of hours an ephemeral (non-persistent) session will stay valid.

        idle_ephemeral_session_lifetime : typing.Optional[int]
            Number of hours for which an ephemeral (non-persistent) session can be inactive before the user must log in again.

        sandbox_version : typing.Optional[str]
            Selected sandbox version for the extensibility environment

        legacy_sandbox_version : typing.Optional[str]
            Selected legacy sandbox version for the extensibility environment

        default_redirection_uri : typing.Optional[str]
            The default absolute redirection uri, must be https

        enabled_locales : typing.Optional[typing.Sequence[UpdateTenantSettingsRequestContentEnabledLocalesItem]]
            Supported locales for the user interface

        session_cookie : typing.Optional[SessionCookieSchema]

        sessions : typing.Optional[TenantSettingsSessions]

        oidc_logout : typing.Optional[TenantOidcLogoutSettings]

        customize_mfa_in_postlogin_action : typing.Optional[bool]
            Whether to enable flexible factors for MFA in the PostLogin action

        allow_organization_name_in_authentication_api : typing.Optional[bool]
            Whether to accept an organization name instead of an ID on auth endpoints

        acr_values_supported : typing.Optional[typing.Sequence[str]]
            Supported ACR values

        mtls : typing.Optional[TenantSettingsMtls]

        pushed_authorization_requests_supported : typing.Optional[bool]
            Enables the use of Pushed Authorization Requests

        authorization_response_iss_parameter_supported : typing.Optional[bool]
            Supports iss parameter in authorization responses

        skip_non_verifiable_callback_uri_confirmation_prompt : typing.Optional[bool]
            Controls whether a confirmation prompt is shown during login flows when the redirect URI uses non-verifiable callback URIs (for example, a custom URI schema such as `myapp://`, or `localhost`).
            If set to true, a confirmation prompt will not be shown. We recommend that this is set to false for improved protection from malicious apps.
            See https://auth0.com/docs/secure/security-guidance/measures-against-app-impersonation for more information.

        resource_parameter_profile : typing.Optional[TenantSettingsResourceParameterProfile]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateTenantSettingsResponseContent
            Tenant settings successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.tenants.settings.update()
        """
        _response = self._raw_client.update(
            change_password=change_password,
            device_flow=device_flow,
            guardian_mfa_page=guardian_mfa_page,
            default_audience=default_audience,
            default_directory=default_directory,
            error_page=error_page,
            default_token_quota=default_token_quota,
            flags=flags,
            friendly_name=friendly_name,
            picture_url=picture_url,
            support_email=support_email,
            support_url=support_url,
            allowed_logout_urls=allowed_logout_urls,
            session_lifetime=session_lifetime,
            idle_session_lifetime=idle_session_lifetime,
            ephemeral_session_lifetime=ephemeral_session_lifetime,
            idle_ephemeral_session_lifetime=idle_ephemeral_session_lifetime,
            sandbox_version=sandbox_version,
            legacy_sandbox_version=legacy_sandbox_version,
            default_redirection_uri=default_redirection_uri,
            enabled_locales=enabled_locales,
            session_cookie=session_cookie,
            sessions=sessions,
            oidc_logout=oidc_logout,
            customize_mfa_in_postlogin_action=customize_mfa_in_postlogin_action,
            allow_organization_name_in_authentication_api=allow_organization_name_in_authentication_api,
            acr_values_supported=acr_values_supported,
            mtls=mtls,
            pushed_authorization_requests_supported=pushed_authorization_requests_supported,
            authorization_response_iss_parameter_supported=authorization_response_iss_parameter_supported,
            skip_non_verifiable_callback_uri_confirmation_prompt=skip_non_verifiable_callback_uri_confirmation_prompt,
            resource_parameter_profile=resource_parameter_profile,
            request_options=request_options,
        )
        return _response.data


class AsyncSettingsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSettingsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSettingsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSettingsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetTenantSettingsResponseContent:
        """
        Retrieve tenant settings. A list of fields to include or exclude may also be specified.

        Parameters
        ----------
        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTenantSettingsResponseContent
            Tenant settings successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tenants.settings.get(
                fields="fields",
                include_fields=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            fields=fields, include_fields=include_fields, request_options=request_options
        )
        return _response.data

    async def update(
        self,
        *,
        change_password: typing.Optional[TenantSettingsPasswordPage] = OMIT,
        device_flow: typing.Optional[TenantSettingsDeviceFlow] = OMIT,
        guardian_mfa_page: typing.Optional[TenantSettingsGuardianPage] = OMIT,
        default_audience: typing.Optional[str] = "",
        default_directory: typing.Optional[str] = "",
        error_page: typing.Optional[TenantSettingsErrorPage] = OMIT,
        default_token_quota: typing.Optional[DefaultTokenQuota] = OMIT,
        flags: typing.Optional[TenantSettingsFlags] = OMIT,
        friendly_name: typing.Optional[str] = "My Company",
        picture_url: typing.Optional[str] = "https://mycompany.org/logo.png",
        support_email: typing.Optional[str] = "support@mycompany.org",
        support_url: typing.Optional[str] = "https://mycompany.org/support",
        allowed_logout_urls: typing.Optional[typing.Sequence[str]] = OMIT,
        session_lifetime: typing.Optional[int] = 168,
        idle_session_lifetime: typing.Optional[int] = 72,
        ephemeral_session_lifetime: typing.Optional[int] = 72,
        idle_ephemeral_session_lifetime: typing.Optional[int] = 24,
        sandbox_version: typing.Optional[str] = "22",
        legacy_sandbox_version: typing.Optional[str] = OMIT,
        default_redirection_uri: typing.Optional[str] = OMIT,
        enabled_locales: typing.Optional[typing.Sequence[UpdateTenantSettingsRequestContentEnabledLocalesItem]] = OMIT,
        session_cookie: typing.Optional[SessionCookieSchema] = OMIT,
        sessions: typing.Optional[TenantSettingsSessions] = OMIT,
        oidc_logout: typing.Optional[TenantOidcLogoutSettings] = OMIT,
        customize_mfa_in_postlogin_action: typing.Optional[bool] = False,
        allow_organization_name_in_authentication_api: typing.Optional[bool] = False,
        acr_values_supported: typing.Optional[typing.Sequence[str]] = OMIT,
        mtls: typing.Optional[TenantSettingsMtls] = OMIT,
        pushed_authorization_requests_supported: typing.Optional[bool] = False,
        authorization_response_iss_parameter_supported: typing.Optional[bool] = False,
        skip_non_verifiable_callback_uri_confirmation_prompt: typing.Optional[bool] = OMIT,
        resource_parameter_profile: typing.Optional[TenantSettingsResourceParameterProfile] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateTenantSettingsResponseContent:
        """
        Update settings for a tenant.

        Parameters
        ----------
        change_password : typing.Optional[TenantSettingsPasswordPage]

        device_flow : typing.Optional[TenantSettingsDeviceFlow]

        guardian_mfa_page : typing.Optional[TenantSettingsGuardianPage]

        default_audience : typing.Optional[str]
            Default audience for API Authorization.

        default_directory : typing.Optional[str]
            Name of connection used for password grants at the `/token` endpoint. The following connection types are supported: LDAP, AD, Database Connections, Passwordless, Windows Azure Active Directory, ADFS.

        error_page : typing.Optional[TenantSettingsErrorPage]

        default_token_quota : typing.Optional[DefaultTokenQuota]

        flags : typing.Optional[TenantSettingsFlags]

        friendly_name : typing.Optional[str]
            Friendly name for this tenant.

        picture_url : typing.Optional[str]
            URL of logo to be shown for this tenant (recommended size: 150x150)

        support_email : typing.Optional[str]
            End-user support email.

        support_url : typing.Optional[str]
            End-user support url.

        allowed_logout_urls : typing.Optional[typing.Sequence[str]]
            URLs that are valid to redirect to after logout from Auth0.

        session_lifetime : typing.Optional[int]
            Number of hours a session will stay valid.

        idle_session_lifetime : typing.Optional[int]
            Number of hours for which a session can be inactive before the user must log in again.

        ephemeral_session_lifetime : typing.Optional[int]
            Number of hours an ephemeral (non-persistent) session will stay valid.

        idle_ephemeral_session_lifetime : typing.Optional[int]
            Number of hours for which an ephemeral (non-persistent) session can be inactive before the user must log in again.

        sandbox_version : typing.Optional[str]
            Selected sandbox version for the extensibility environment

        legacy_sandbox_version : typing.Optional[str]
            Selected legacy sandbox version for the extensibility environment

        default_redirection_uri : typing.Optional[str]
            The default absolute redirection uri, must be https

        enabled_locales : typing.Optional[typing.Sequence[UpdateTenantSettingsRequestContentEnabledLocalesItem]]
            Supported locales for the user interface

        session_cookie : typing.Optional[SessionCookieSchema]

        sessions : typing.Optional[TenantSettingsSessions]

        oidc_logout : typing.Optional[TenantOidcLogoutSettings]

        customize_mfa_in_postlogin_action : typing.Optional[bool]
            Whether to enable flexible factors for MFA in the PostLogin action

        allow_organization_name_in_authentication_api : typing.Optional[bool]
            Whether to accept an organization name instead of an ID on auth endpoints

        acr_values_supported : typing.Optional[typing.Sequence[str]]
            Supported ACR values

        mtls : typing.Optional[TenantSettingsMtls]

        pushed_authorization_requests_supported : typing.Optional[bool]
            Enables the use of Pushed Authorization Requests

        authorization_response_iss_parameter_supported : typing.Optional[bool]
            Supports iss parameter in authorization responses

        skip_non_verifiable_callback_uri_confirmation_prompt : typing.Optional[bool]
            Controls whether a confirmation prompt is shown during login flows when the redirect URI uses non-verifiable callback URIs (for example, a custom URI schema such as `myapp://`, or `localhost`).
            If set to true, a confirmation prompt will not be shown. We recommend that this is set to false for improved protection from malicious apps.
            See https://auth0.com/docs/secure/security-guidance/measures-against-app-impersonation for more information.

        resource_parameter_profile : typing.Optional[TenantSettingsResourceParameterProfile]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateTenantSettingsResponseContent
            Tenant settings successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tenants.settings.update()


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            change_password=change_password,
            device_flow=device_flow,
            guardian_mfa_page=guardian_mfa_page,
            default_audience=default_audience,
            default_directory=default_directory,
            error_page=error_page,
            default_token_quota=default_token_quota,
            flags=flags,
            friendly_name=friendly_name,
            picture_url=picture_url,
            support_email=support_email,
            support_url=support_url,
            allowed_logout_urls=allowed_logout_urls,
            session_lifetime=session_lifetime,
            idle_session_lifetime=idle_session_lifetime,
            ephemeral_session_lifetime=ephemeral_session_lifetime,
            idle_ephemeral_session_lifetime=idle_ephemeral_session_lifetime,
            sandbox_version=sandbox_version,
            legacy_sandbox_version=legacy_sandbox_version,
            default_redirection_uri=default_redirection_uri,
            enabled_locales=enabled_locales,
            session_cookie=session_cookie,
            sessions=sessions,
            oidc_logout=oidc_logout,
            customize_mfa_in_postlogin_action=customize_mfa_in_postlogin_action,
            allow_organization_name_in_authentication_api=allow_organization_name_in_authentication_api,
            acr_values_supported=acr_values_supported,
            mtls=mtls,
            pushed_authorization_requests_supported=pushed_authorization_requests_supported,
            authorization_response_iss_parameter_supported=authorization_response_iss_parameter_supported,
            skip_non_verifiable_callback_uri_confirmation_prompt=skip_non_verifiable_callback_uri_confirmation_prompt,
            resource_parameter_profile=resource_parameter_profile,
            request_options=request_options,
        )
        return _response.data
