# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.bad_request_error import BadRequestError
from ...errors.forbidden_error import ForbiddenError
from ...errors.too_many_requests_error import TooManyRequestsError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.default_token_quota import DefaultTokenQuota
from ...types.get_tenant_settings_response_content import GetTenantSettingsResponseContent
from ...types.session_cookie_schema import SessionCookieSchema
from ...types.tenant_oidc_logout_settings import TenantOidcLogoutSettings
from ...types.tenant_settings_device_flow import TenantSettingsDeviceFlow
from ...types.tenant_settings_error_page import TenantSettingsErrorPage
from ...types.tenant_settings_flags import TenantSettingsFlags
from ...types.tenant_settings_guardian_page import TenantSettingsGuardianPage
from ...types.tenant_settings_mtls import TenantSettingsMtls
from ...types.tenant_settings_password_page import TenantSettingsPasswordPage
from ...types.tenant_settings_resource_parameter_profile import TenantSettingsResourceParameterProfile
from ...types.tenant_settings_sessions import TenantSettingsSessions
from ...types.update_tenant_settings_response_content import UpdateTenantSettingsResponseContent
from .types.update_tenant_settings_request_content_enabled_locales_item import (
    UpdateTenantSettingsRequestContentEnabledLocalesItem,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawSettingsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetTenantSettingsResponseContent]:
        """
        Retrieve tenant settings. A list of fields to include or exclude may also be specified.

        Parameters
        ----------
        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetTenantSettingsResponseContent]
            Tenant settings successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            "tenants/settings",
            method="GET",
            params={
                "fields": fields,
                "include_fields": include_fields,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTenantSettingsResponseContent,
                    parse_obj_as(
                        type_=GetTenantSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        *,
        change_password: typing.Optional[TenantSettingsPasswordPage] = OMIT,
        device_flow: typing.Optional[TenantSettingsDeviceFlow] = OMIT,
        guardian_mfa_page: typing.Optional[TenantSettingsGuardianPage] = OMIT,
        default_audience: typing.Optional[str] = "",
        default_directory: typing.Optional[str] = "",
        error_page: typing.Optional[TenantSettingsErrorPage] = OMIT,
        default_token_quota: typing.Optional[DefaultTokenQuota] = OMIT,
        flags: typing.Optional[TenantSettingsFlags] = OMIT,
        friendly_name: typing.Optional[str] = "My Company",
        picture_url: typing.Optional[str] = "https://mycompany.org/logo.png",
        support_email: typing.Optional[str] = "support@mycompany.org",
        support_url: typing.Optional[str] = "https://mycompany.org/support",
        allowed_logout_urls: typing.Optional[typing.Sequence[str]] = OMIT,
        session_lifetime: typing.Optional[int] = 168,
        idle_session_lifetime: typing.Optional[int] = 72,
        ephemeral_session_lifetime: typing.Optional[int] = 72,
        idle_ephemeral_session_lifetime: typing.Optional[int] = 24,
        sandbox_version: typing.Optional[str] = "22",
        legacy_sandbox_version: typing.Optional[str] = OMIT,
        default_redirection_uri: typing.Optional[str] = OMIT,
        enabled_locales: typing.Optional[typing.Sequence[UpdateTenantSettingsRequestContentEnabledLocalesItem]] = OMIT,
        session_cookie: typing.Optional[SessionCookieSchema] = OMIT,
        sessions: typing.Optional[TenantSettingsSessions] = OMIT,
        oidc_logout: typing.Optional[TenantOidcLogoutSettings] = OMIT,
        customize_mfa_in_postlogin_action: typing.Optional[bool] = False,
        allow_organization_name_in_authentication_api: typing.Optional[bool] = False,
        acr_values_supported: typing.Optional[typing.Sequence[str]] = OMIT,
        mtls: typing.Optional[TenantSettingsMtls] = OMIT,
        pushed_authorization_requests_supported: typing.Optional[bool] = False,
        authorization_response_iss_parameter_supported: typing.Optional[bool] = False,
        skip_non_verifiable_callback_uri_confirmation_prompt: typing.Optional[bool] = OMIT,
        resource_parameter_profile: typing.Optional[TenantSettingsResourceParameterProfile] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateTenantSettingsResponseContent]:
        """
        Update settings for a tenant.

        Parameters
        ----------
        change_password : typing.Optional[TenantSettingsPasswordPage]

        device_flow : typing.Optional[TenantSettingsDeviceFlow]

        guardian_mfa_page : typing.Optional[TenantSettingsGuardianPage]

        default_audience : typing.Optional[str]
            Default audience for API Authorization.

        default_directory : typing.Optional[str]
            Name of connection used for password grants at the `/token` endpoint. The following connection types are supported: LDAP, AD, Database Connections, Passwordless, Windows Azure Active Directory, ADFS.

        error_page : typing.Optional[TenantSettingsErrorPage]

        default_token_quota : typing.Optional[DefaultTokenQuota]

        flags : typing.Optional[TenantSettingsFlags]

        friendly_name : typing.Optional[str]
            Friendly name for this tenant.

        picture_url : typing.Optional[str]
            URL of logo to be shown for this tenant (recommended size: 150x150)

        support_email : typing.Optional[str]
            End-user support email.

        support_url : typing.Optional[str]
            End-user support url.

        allowed_logout_urls : typing.Optional[typing.Sequence[str]]
            URLs that are valid to redirect to after logout from Auth0.

        session_lifetime : typing.Optional[int]
            Number of hours a session will stay valid.

        idle_session_lifetime : typing.Optional[int]
            Number of hours for which a session can be inactive before the user must log in again.

        ephemeral_session_lifetime : typing.Optional[int]
            Number of hours an ephemeral (non-persistent) session will stay valid.

        idle_ephemeral_session_lifetime : typing.Optional[int]
            Number of hours for which an ephemeral (non-persistent) session can be inactive before the user must log in again.

        sandbox_version : typing.Optional[str]
            Selected sandbox version for the extensibility environment

        legacy_sandbox_version : typing.Optional[str]
            Selected legacy sandbox version for the extensibility environment

        default_redirection_uri : typing.Optional[str]
            The default absolute redirection uri, must be https

        enabled_locales : typing.Optional[typing.Sequence[UpdateTenantSettingsRequestContentEnabledLocalesItem]]
            Supported locales for the user interface

        session_cookie : typing.Optional[SessionCookieSchema]

        sessions : typing.Optional[TenantSettingsSessions]

        oidc_logout : typing.Optional[TenantOidcLogoutSettings]

        customize_mfa_in_postlogin_action : typing.Optional[bool]
            Whether to enable flexible factors for MFA in the PostLogin action

        allow_organization_name_in_authentication_api : typing.Optional[bool]
            Whether to accept an organization name instead of an ID on auth endpoints

        acr_values_supported : typing.Optional[typing.Sequence[str]]
            Supported ACR values

        mtls : typing.Optional[TenantSettingsMtls]

        pushed_authorization_requests_supported : typing.Optional[bool]
            Enables the use of Pushed Authorization Requests

        authorization_response_iss_parameter_supported : typing.Optional[bool]
            Supports iss parameter in authorization responses

        skip_non_verifiable_callback_uri_confirmation_prompt : typing.Optional[bool]
            Controls whether a confirmation prompt is shown during login flows when the redirect URI uses non-verifiable callback URIs (for example, a custom URI schema such as `myapp://`, or `localhost`).
            If set to true, a confirmation prompt will not be shown. We recommend that this is set to false for improved protection from malicious apps.
            See https://auth0.com/docs/secure/security-guidance/measures-against-app-impersonation for more information.

        resource_parameter_profile : typing.Optional[TenantSettingsResourceParameterProfile]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateTenantSettingsResponseContent]
            Tenant settings successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "tenants/settings",
            method="PATCH",
            json={
                "change_password": convert_and_respect_annotation_metadata(
                    object_=change_password, annotation=typing.Optional[TenantSettingsPasswordPage], direction="write"
                ),
                "device_flow": convert_and_respect_annotation_metadata(
                    object_=device_flow, annotation=typing.Optional[TenantSettingsDeviceFlow], direction="write"
                ),
                "guardian_mfa_page": convert_and_respect_annotation_metadata(
                    object_=guardian_mfa_page, annotation=typing.Optional[TenantSettingsGuardianPage], direction="write"
                ),
                "default_audience": default_audience,
                "default_directory": default_directory,
                "error_page": convert_and_respect_annotation_metadata(
                    object_=error_page, annotation=typing.Optional[TenantSettingsErrorPage], direction="write"
                ),
                "default_token_quota": convert_and_respect_annotation_metadata(
                    object_=default_token_quota, annotation=typing.Optional[DefaultTokenQuota], direction="write"
                ),
                "flags": convert_and_respect_annotation_metadata(
                    object_=flags, annotation=TenantSettingsFlags, direction="write"
                ),
                "friendly_name": friendly_name,
                "picture_url": picture_url,
                "support_email": support_email,
                "support_url": support_url,
                "allowed_logout_urls": allowed_logout_urls,
                "session_lifetime": session_lifetime,
                "idle_session_lifetime": idle_session_lifetime,
                "ephemeral_session_lifetime": ephemeral_session_lifetime,
                "idle_ephemeral_session_lifetime": idle_ephemeral_session_lifetime,
                "sandbox_version": sandbox_version,
                "legacy_sandbox_version": legacy_sandbox_version,
                "default_redirection_uri": default_redirection_uri,
                "enabled_locales": enabled_locales,
                "session_cookie": convert_and_respect_annotation_metadata(
                    object_=session_cookie, annotation=typing.Optional[SessionCookieSchema], direction="write"
                ),
                "sessions": convert_and_respect_annotation_metadata(
                    object_=sessions, annotation=typing.Optional[TenantSettingsSessions], direction="write"
                ),
                "oidc_logout": convert_and_respect_annotation_metadata(
                    object_=oidc_logout, annotation=TenantOidcLogoutSettings, direction="write"
                ),
                "customize_mfa_in_postlogin_action": customize_mfa_in_postlogin_action,
                "allow_organization_name_in_authentication_api": allow_organization_name_in_authentication_api,
                "acr_values_supported": acr_values_supported,
                "mtls": convert_and_respect_annotation_metadata(
                    object_=mtls, annotation=typing.Optional[TenantSettingsMtls], direction="write"
                ),
                "pushed_authorization_requests_supported": pushed_authorization_requests_supported,
                "authorization_response_iss_parameter_supported": authorization_response_iss_parameter_supported,
                "skip_non_verifiable_callback_uri_confirmation_prompt": skip_non_verifiable_callback_uri_confirmation_prompt,
                "resource_parameter_profile": resource_parameter_profile,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateTenantSettingsResponseContent,
                    parse_obj_as(
                        type_=UpdateTenantSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawSettingsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetTenantSettingsResponseContent]:
        """
        Retrieve tenant settings. A list of fields to include or exclude may also be specified.

        Parameters
        ----------
        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetTenantSettingsResponseContent]
            Tenant settings successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "tenants/settings",
            method="GET",
            params={
                "fields": fields,
                "include_fields": include_fields,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTenantSettingsResponseContent,
                    parse_obj_as(
                        type_=GetTenantSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        *,
        change_password: typing.Optional[TenantSettingsPasswordPage] = OMIT,
        device_flow: typing.Optional[TenantSettingsDeviceFlow] = OMIT,
        guardian_mfa_page: typing.Optional[TenantSettingsGuardianPage] = OMIT,
        default_audience: typing.Optional[str] = "",
        default_directory: typing.Optional[str] = "",
        error_page: typing.Optional[TenantSettingsErrorPage] = OMIT,
        default_token_quota: typing.Optional[DefaultTokenQuota] = OMIT,
        flags: typing.Optional[TenantSettingsFlags] = OMIT,
        friendly_name: typing.Optional[str] = "My Company",
        picture_url: typing.Optional[str] = "https://mycompany.org/logo.png",
        support_email: typing.Optional[str] = "support@mycompany.org",
        support_url: typing.Optional[str] = "https://mycompany.org/support",
        allowed_logout_urls: typing.Optional[typing.Sequence[str]] = OMIT,
        session_lifetime: typing.Optional[int] = 168,
        idle_session_lifetime: typing.Optional[int] = 72,
        ephemeral_session_lifetime: typing.Optional[int] = 72,
        idle_ephemeral_session_lifetime: typing.Optional[int] = 24,
        sandbox_version: typing.Optional[str] = "22",
        legacy_sandbox_version: typing.Optional[str] = OMIT,
        default_redirection_uri: typing.Optional[str] = OMIT,
        enabled_locales: typing.Optional[typing.Sequence[UpdateTenantSettingsRequestContentEnabledLocalesItem]] = OMIT,
        session_cookie: typing.Optional[SessionCookieSchema] = OMIT,
        sessions: typing.Optional[TenantSettingsSessions] = OMIT,
        oidc_logout: typing.Optional[TenantOidcLogoutSettings] = OMIT,
        customize_mfa_in_postlogin_action: typing.Optional[bool] = False,
        allow_organization_name_in_authentication_api: typing.Optional[bool] = False,
        acr_values_supported: typing.Optional[typing.Sequence[str]] = OMIT,
        mtls: typing.Optional[TenantSettingsMtls] = OMIT,
        pushed_authorization_requests_supported: typing.Optional[bool] = False,
        authorization_response_iss_parameter_supported: typing.Optional[bool] = False,
        skip_non_verifiable_callback_uri_confirmation_prompt: typing.Optional[bool] = OMIT,
        resource_parameter_profile: typing.Optional[TenantSettingsResourceParameterProfile] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateTenantSettingsResponseContent]:
        """
        Update settings for a tenant.

        Parameters
        ----------
        change_password : typing.Optional[TenantSettingsPasswordPage]

        device_flow : typing.Optional[TenantSettingsDeviceFlow]

        guardian_mfa_page : typing.Optional[TenantSettingsGuardianPage]

        default_audience : typing.Optional[str]
            Default audience for API Authorization.

        default_directory : typing.Optional[str]
            Name of connection used for password grants at the `/token` endpoint. The following connection types are supported: LDAP, AD, Database Connections, Passwordless, Windows Azure Active Directory, ADFS.

        error_page : typing.Optional[TenantSettingsErrorPage]

        default_token_quota : typing.Optional[DefaultTokenQuota]

        flags : typing.Optional[TenantSettingsFlags]

        friendly_name : typing.Optional[str]
            Friendly name for this tenant.

        picture_url : typing.Optional[str]
            URL of logo to be shown for this tenant (recommended size: 150x150)

        support_email : typing.Optional[str]
            End-user support email.

        support_url : typing.Optional[str]
            End-user support url.

        allowed_logout_urls : typing.Optional[typing.Sequence[str]]
            URLs that are valid to redirect to after logout from Auth0.

        session_lifetime : typing.Optional[int]
            Number of hours a session will stay valid.

        idle_session_lifetime : typing.Optional[int]
            Number of hours for which a session can be inactive before the user must log in again.

        ephemeral_session_lifetime : typing.Optional[int]
            Number of hours an ephemeral (non-persistent) session will stay valid.

        idle_ephemeral_session_lifetime : typing.Optional[int]
            Number of hours for which an ephemeral (non-persistent) session can be inactive before the user must log in again.

        sandbox_version : typing.Optional[str]
            Selected sandbox version for the extensibility environment

        legacy_sandbox_version : typing.Optional[str]
            Selected legacy sandbox version for the extensibility environment

        default_redirection_uri : typing.Optional[str]
            The default absolute redirection uri, must be https

        enabled_locales : typing.Optional[typing.Sequence[UpdateTenantSettingsRequestContentEnabledLocalesItem]]
            Supported locales for the user interface

        session_cookie : typing.Optional[SessionCookieSchema]

        sessions : typing.Optional[TenantSettingsSessions]

        oidc_logout : typing.Optional[TenantOidcLogoutSettings]

        customize_mfa_in_postlogin_action : typing.Optional[bool]
            Whether to enable flexible factors for MFA in the PostLogin action

        allow_organization_name_in_authentication_api : typing.Optional[bool]
            Whether to accept an organization name instead of an ID on auth endpoints

        acr_values_supported : typing.Optional[typing.Sequence[str]]
            Supported ACR values

        mtls : typing.Optional[TenantSettingsMtls]

        pushed_authorization_requests_supported : typing.Optional[bool]
            Enables the use of Pushed Authorization Requests

        authorization_response_iss_parameter_supported : typing.Optional[bool]
            Supports iss parameter in authorization responses

        skip_non_verifiable_callback_uri_confirmation_prompt : typing.Optional[bool]
            Controls whether a confirmation prompt is shown during login flows when the redirect URI uses non-verifiable callback URIs (for example, a custom URI schema such as `myapp://`, or `localhost`).
            If set to true, a confirmation prompt will not be shown. We recommend that this is set to false for improved protection from malicious apps.
            See https://auth0.com/docs/secure/security-guidance/measures-against-app-impersonation for more information.

        resource_parameter_profile : typing.Optional[TenantSettingsResourceParameterProfile]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateTenantSettingsResponseContent]
            Tenant settings successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "tenants/settings",
            method="PATCH",
            json={
                "change_password": convert_and_respect_annotation_metadata(
                    object_=change_password, annotation=typing.Optional[TenantSettingsPasswordPage], direction="write"
                ),
                "device_flow": convert_and_respect_annotation_metadata(
                    object_=device_flow, annotation=typing.Optional[TenantSettingsDeviceFlow], direction="write"
                ),
                "guardian_mfa_page": convert_and_respect_annotation_metadata(
                    object_=guardian_mfa_page, annotation=typing.Optional[TenantSettingsGuardianPage], direction="write"
                ),
                "default_audience": default_audience,
                "default_directory": default_directory,
                "error_page": convert_and_respect_annotation_metadata(
                    object_=error_page, annotation=typing.Optional[TenantSettingsErrorPage], direction="write"
                ),
                "default_token_quota": convert_and_respect_annotation_metadata(
                    object_=default_token_quota, annotation=typing.Optional[DefaultTokenQuota], direction="write"
                ),
                "flags": convert_and_respect_annotation_metadata(
                    object_=flags, annotation=TenantSettingsFlags, direction="write"
                ),
                "friendly_name": friendly_name,
                "picture_url": picture_url,
                "support_email": support_email,
                "support_url": support_url,
                "allowed_logout_urls": allowed_logout_urls,
                "session_lifetime": session_lifetime,
                "idle_session_lifetime": idle_session_lifetime,
                "ephemeral_session_lifetime": ephemeral_session_lifetime,
                "idle_ephemeral_session_lifetime": idle_ephemeral_session_lifetime,
                "sandbox_version": sandbox_version,
                "legacy_sandbox_version": legacy_sandbox_version,
                "default_redirection_uri": default_redirection_uri,
                "enabled_locales": enabled_locales,
                "session_cookie": convert_and_respect_annotation_metadata(
                    object_=session_cookie, annotation=typing.Optional[SessionCookieSchema], direction="write"
                ),
                "sessions": convert_and_respect_annotation_metadata(
                    object_=sessions, annotation=typing.Optional[TenantSettingsSessions], direction="write"
                ),
                "oidc_logout": convert_and_respect_annotation_metadata(
                    object_=oidc_logout, annotation=TenantOidcLogoutSettings, direction="write"
                ),
                "customize_mfa_in_postlogin_action": customize_mfa_in_postlogin_action,
                "allow_organization_name_in_authentication_api": allow_organization_name_in_authentication_api,
                "acr_values_supported": acr_values_supported,
                "mtls": convert_and_respect_annotation_metadata(
                    object_=mtls, annotation=typing.Optional[TenantSettingsMtls], direction="write"
                ),
                "pushed_authorization_requests_supported": pushed_authorization_requests_supported,
                "authorization_response_iss_parameter_supported": authorization_response_iss_parameter_supported,
                "skip_non_verifiable_callback_uri_confirmation_prompt": skip_non_verifiable_callback_uri_confirmation_prompt,
                "resource_parameter_profile": resource_parameter_profile,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateTenantSettingsResponseContent,
                    parse_obj_as(
                        type_=UpdateTenantSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
