# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.change_password_ticket_identity import ChangePasswordTicketIdentity
from ..types.change_password_ticket_response_content import ChangePasswordTicketResponseContent
from ..types.identity import Identity
from ..types.verify_email_ticket_response_content import VerifyEmailTicketResponseContent
from .raw_client import AsyncRawTicketsClient, RawTicketsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TicketsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTicketsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTicketsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTicketsClient
        """
        return self._raw_client

    def verify_email(
        self,
        *,
        user_id: str,
        result_url: typing.Optional[str] = "http://myapp.com/callback",
        client_id: typing.Optional[str] = "DaM8bokEXBWrTUFCiJjWn50jei6ardyX",
        organization_id: typing.Optional[str] = "org_2eondWoxcMIpaLQc",
        ttl_sec: typing.Optional[int] = OMIT,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        identity: typing.Optional[Identity] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> VerifyEmailTicketResponseContent:
        """
        Create an email verification ticket for a given user. An email verification ticket is a generated URL that the user can consume to verify their email address.

        Parameters
        ----------
        user_id : str
            user_id of for whom the ticket should be created.

        result_url : typing.Optional[str]
            URL the user will be redirected to in the classic Universal Login experience once the ticket is used. Cannot be specified when using client_id or organization_id.

        client_id : typing.Optional[str]
            ID of the client (application). If provided for tenants using the New Universal Login experience, the email template and UI displays application details, and the user is prompted to redirect to the application's <a target='' href='https://auth0.com/docs/authenticate/login/auth0-universal-login/configure-default-login-routes#completing-the-password-reset-flow'>default login route</a> after the ticket is used. client_id is required to use the <a target='' href='https://auth0.com/docs/customize/actions/flows-and-triggers/post-change-password-flow'>Password Reset Post Challenge</a> trigger.

        organization_id : typing.Optional[str]
            (Optional) Organization ID – the ID of the Organization. If provided, organization parameters will be made available to the email template and organization branding will be applied to the prompt. In addition, the redirect link in the prompt will include organization_id and organization_name query string parameters.

        ttl_sec : typing.Optional[int]
            Number of seconds for which the ticket is valid before expiration. If unspecified or set to 0, this value defaults to 432000 seconds (5 days).

        include_email_in_redirect : typing.Optional[bool]
            Whether to include the email address as part of the returnUrl in the reset_email (true), or not (false).

        identity : typing.Optional[Identity]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VerifyEmailTicketResponseContent
            Ticket successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.tickets.verify_email(
            user_id="user_id",
        )
        """
        _response = self._raw_client.verify_email(
            user_id=user_id,
            result_url=result_url,
            client_id=client_id,
            organization_id=organization_id,
            ttl_sec=ttl_sec,
            include_email_in_redirect=include_email_in_redirect,
            identity=identity,
            request_options=request_options,
        )
        return _response.data

    def change_password(
        self,
        *,
        result_url: typing.Optional[str] = "http://myapp.com/callback",
        user_id: typing.Optional[str] = OMIT,
        client_id: typing.Optional[str] = "DaM8bokEXBWrTUFCiJjWn50jei6ardyX",
        organization_id: typing.Optional[str] = "org_2eondWoxcMIpaLQc",
        connection_id: typing.Optional[str] = "con_0000000000000001",
        email: typing.Optional[str] = OMIT,
        ttl_sec: typing.Optional[int] = OMIT,
        mark_email_as_verified: typing.Optional[bool] = False,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        identity: typing.Optional[ChangePasswordTicketIdentity] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ChangePasswordTicketResponseContent:
        """
        Create a password change ticket for a given user. A password change ticket is a generated URL that the user can consume to start a reset password flow.

        Note: This endpoint does not verify the given user’s identity. If you call this endpoint within your application, you must design your application to verify the user’s identity.

        Parameters
        ----------
        result_url : typing.Optional[str]
            URL the user will be redirected to in the classic Universal Login experience once the ticket is used. Cannot be specified when using client_id or organization_id.

        user_id : typing.Optional[str]
            user_id of for whom the ticket should be created.

        client_id : typing.Optional[str]
            ID of the client (application). If provided for tenants using the New Universal Login experience, the email template and UI displays application details, and the user is prompted to redirect to the application's <a target='' href='https://auth0.com/docs/authenticate/login/auth0-universal-login/configure-default-login-routes#completing-the-password-reset-flow'>default login route</a> after the ticket is used. client_id is required to use the <a target='' href='https://auth0.com/docs/customize/actions/flows-and-triggers/post-change-password-flow'>Password Reset Post Challenge</a> trigger.

        organization_id : typing.Optional[str]
            (Optional) Organization ID – the ID of the Organization. If provided, organization parameters will be made available to the email template and organization branding will be applied to the prompt. In addition, the redirect link in the prompt will include organization_id and organization_name query string parameters.

        connection_id : typing.Optional[str]
            ID of the connection. If provided, allows the user to be specified using email instead of user_id. If you set this value, you must also send the email parameter. You cannot send user_id when specifying a connection_id.

        email : typing.Optional[str]
            Email address of the user for whom the tickets should be created. Requires the connection_id parameter. Cannot be specified when using user_id.

        ttl_sec : typing.Optional[int]
            Number of seconds for which the ticket is valid before expiration. If unspecified or set to 0, this value defaults to 432000 seconds (5 days).

        mark_email_as_verified : typing.Optional[bool]
            Whether to set the email_verified attribute to true (true) or whether it should not be updated (false).

        include_email_in_redirect : typing.Optional[bool]
            Whether to include the email address as part of the returnUrl in the reset_email (true), or not (false).

        identity : typing.Optional[ChangePasswordTicketIdentity]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChangePasswordTicketResponseContent
            Ticket successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.tickets.change_password()
        """
        _response = self._raw_client.change_password(
            result_url=result_url,
            user_id=user_id,
            client_id=client_id,
            organization_id=organization_id,
            connection_id=connection_id,
            email=email,
            ttl_sec=ttl_sec,
            mark_email_as_verified=mark_email_as_verified,
            include_email_in_redirect=include_email_in_redirect,
            identity=identity,
            request_options=request_options,
        )
        return _response.data


class AsyncTicketsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTicketsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTicketsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTicketsClient
        """
        return self._raw_client

    async def verify_email(
        self,
        *,
        user_id: str,
        result_url: typing.Optional[str] = "http://myapp.com/callback",
        client_id: typing.Optional[str] = "DaM8bokEXBWrTUFCiJjWn50jei6ardyX",
        organization_id: typing.Optional[str] = "org_2eondWoxcMIpaLQc",
        ttl_sec: typing.Optional[int] = OMIT,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        identity: typing.Optional[Identity] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> VerifyEmailTicketResponseContent:
        """
        Create an email verification ticket for a given user. An email verification ticket is a generated URL that the user can consume to verify their email address.

        Parameters
        ----------
        user_id : str
            user_id of for whom the ticket should be created.

        result_url : typing.Optional[str]
            URL the user will be redirected to in the classic Universal Login experience once the ticket is used. Cannot be specified when using client_id or organization_id.

        client_id : typing.Optional[str]
            ID of the client (application). If provided for tenants using the New Universal Login experience, the email template and UI displays application details, and the user is prompted to redirect to the application's <a target='' href='https://auth0.com/docs/authenticate/login/auth0-universal-login/configure-default-login-routes#completing-the-password-reset-flow'>default login route</a> after the ticket is used. client_id is required to use the <a target='' href='https://auth0.com/docs/customize/actions/flows-and-triggers/post-change-password-flow'>Password Reset Post Challenge</a> trigger.

        organization_id : typing.Optional[str]
            (Optional) Organization ID – the ID of the Organization. If provided, organization parameters will be made available to the email template and organization branding will be applied to the prompt. In addition, the redirect link in the prompt will include organization_id and organization_name query string parameters.

        ttl_sec : typing.Optional[int]
            Number of seconds for which the ticket is valid before expiration. If unspecified or set to 0, this value defaults to 432000 seconds (5 days).

        include_email_in_redirect : typing.Optional[bool]
            Whether to include the email address as part of the returnUrl in the reset_email (true), or not (false).

        identity : typing.Optional[Identity]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VerifyEmailTicketResponseContent
            Ticket successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tickets.verify_email(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.verify_email(
            user_id=user_id,
            result_url=result_url,
            client_id=client_id,
            organization_id=organization_id,
            ttl_sec=ttl_sec,
            include_email_in_redirect=include_email_in_redirect,
            identity=identity,
            request_options=request_options,
        )
        return _response.data

    async def change_password(
        self,
        *,
        result_url: typing.Optional[str] = "http://myapp.com/callback",
        user_id: typing.Optional[str] = OMIT,
        client_id: typing.Optional[str] = "DaM8bokEXBWrTUFCiJjWn50jei6ardyX",
        organization_id: typing.Optional[str] = "org_2eondWoxcMIpaLQc",
        connection_id: typing.Optional[str] = "con_0000000000000001",
        email: typing.Optional[str] = OMIT,
        ttl_sec: typing.Optional[int] = OMIT,
        mark_email_as_verified: typing.Optional[bool] = False,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        identity: typing.Optional[ChangePasswordTicketIdentity] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ChangePasswordTicketResponseContent:
        """
        Create a password change ticket for a given user. A password change ticket is a generated URL that the user can consume to start a reset password flow.

        Note: This endpoint does not verify the given user’s identity. If you call this endpoint within your application, you must design your application to verify the user’s identity.

        Parameters
        ----------
        result_url : typing.Optional[str]
            URL the user will be redirected to in the classic Universal Login experience once the ticket is used. Cannot be specified when using client_id or organization_id.

        user_id : typing.Optional[str]
            user_id of for whom the ticket should be created.

        client_id : typing.Optional[str]
            ID of the client (application). If provided for tenants using the New Universal Login experience, the email template and UI displays application details, and the user is prompted to redirect to the application's <a target='' href='https://auth0.com/docs/authenticate/login/auth0-universal-login/configure-default-login-routes#completing-the-password-reset-flow'>default login route</a> after the ticket is used. client_id is required to use the <a target='' href='https://auth0.com/docs/customize/actions/flows-and-triggers/post-change-password-flow'>Password Reset Post Challenge</a> trigger.

        organization_id : typing.Optional[str]
            (Optional) Organization ID – the ID of the Organization. If provided, organization parameters will be made available to the email template and organization branding will be applied to the prompt. In addition, the redirect link in the prompt will include organization_id and organization_name query string parameters.

        connection_id : typing.Optional[str]
            ID of the connection. If provided, allows the user to be specified using email instead of user_id. If you set this value, you must also send the email parameter. You cannot send user_id when specifying a connection_id.

        email : typing.Optional[str]
            Email address of the user for whom the tickets should be created. Requires the connection_id parameter. Cannot be specified when using user_id.

        ttl_sec : typing.Optional[int]
            Number of seconds for which the ticket is valid before expiration. If unspecified or set to 0, this value defaults to 432000 seconds (5 days).

        mark_email_as_verified : typing.Optional[bool]
            Whether to set the email_verified attribute to true (true) or whether it should not be updated (false).

        include_email_in_redirect : typing.Optional[bool]
            Whether to include the email address as part of the returnUrl in the reset_email (true), or not (false).

        identity : typing.Optional[ChangePasswordTicketIdentity]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChangePasswordTicketResponseContent
            Ticket successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tickets.change_password()


        asyncio.run(main())
        """
        _response = await self._raw_client.change_password(
            result_url=result_url,
            user_id=user_id,
            client_id=client_id,
            organization_id=organization_id,
            connection_id=connection_id,
            email=email,
            ttl_sec=ttl_sec,
            mark_email_as_verified=mark_email_as_verified,
            include_email_in_redirect=include_email_in_redirect,
            identity=identity,
            request_options=request_options,
        )
        return _response.data
