# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.create_token_exchange_profile_response_content import CreateTokenExchangeProfileResponseContent
from ..types.get_token_exchange_profile_response_content import GetTokenExchangeProfileResponseContent
from ..types.list_token_exchange_profile_response_content import ListTokenExchangeProfileResponseContent
from ..types.token_exchange_profile_response_content import TokenExchangeProfileResponseContent
from .raw_client import AsyncRawTokenExchangeProfilesClient, RawTokenExchangeProfilesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TokenExchangeProfilesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTokenExchangeProfilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTokenExchangeProfilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTokenExchangeProfilesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[TokenExchangeProfileResponseContent, ListTokenExchangeProfileResponseContent]:
        """
        Retrieve a list of all Token Exchange Profiles available in your tenant.

        By using this feature, you agree to the applicable Free Trial terms in <a href="https://www.okta.com/legal/">Okta’s Master Subscription Agreement</a>. It is your responsibility to securely validate the user’s subject_token. See <a href="https://auth0.com/docs/authenticate/custom-token-exchange">User Guide</a> for more details.

        This endpoint supports Checkpoint pagination. To search by checkpoint, use the following parameters:
        <ul>
        <li><code>from</code>: Optional id from which to start selection.</li>
        <li><code>take</code>: The total amount of entries to retrieve when using the from parameter. Defaults to 50.</li>
        </ul>

        <b>Note</b>: The first time you call this endpoint using checkpoint pagination, omit the <code>from</code> parameter. If there are more results, a <code>next</code> value is included in the response. You can use this for subsequent API calls. When <code>next</code> is no longer included in the response, no pages are remaining.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[TokenExchangeProfileResponseContent, ListTokenExchangeProfileResponseContent]
            Token Exchange Profile successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.token_exchange_profiles.list(
            from_="from",
            take=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(from_=from_, take=take, request_options=request_options)

    def create(
        self,
        *,
        name: str = "Token Exchange Profile 1",
        subject_token_type: str,
        action_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateTokenExchangeProfileResponseContent:
        """
        Create a new Token Exchange Profile within your tenant.

        By using this feature, you agree to the applicable Free Trial terms in <a href="https://www.okta.com/legal/">Okta’s Master Subscription Agreement</a>. It is your responsibility to securely validate the user’s subject_token. See <a href="https://auth0.com/docs/authenticate/custom-token-exchange">User Guide</a> for more details.

        Parameters
        ----------
        name : str
            Friendly name of this profile.

        subject_token_type : str
            Subject token type for this profile. When receiving a token exchange request on the Authentication API, the corresponding token exchange profile with a matching subject_token_type will be executed. This must be a URI.

        action_id : str
            The ID of the Custom Token Exchange action to execute for this profile, in order to validate the subject_token. The action must use the custom-token-exchange trigger.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateTokenExchangeProfileResponseContent
            Token exchange profile successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.token_exchange_profiles.create(
            name="name",
            subject_token_type="subject_token_type",
            action_id="action_id",
        )
        """
        _response = self._raw_client.create(
            name=name, subject_token_type=subject_token_type, action_id=action_id, request_options=request_options
        )
        return _response.data

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTokenExchangeProfileResponseContent:
        """
        Retrieve details about a single Token Exchange Profile specified by ID.

        By using this feature, you agree to the applicable Free Trial terms in <a href="https://www.okta.com/legal/">Okta’s Master Subscription Agreement</a>. It is your responsibility to securely validate the user’s subject_token. See <a href="https://auth0.com/docs/authenticate/custom-token-exchange">User Guide</a> for more details.

        Parameters
        ----------
        id : str
            ID of the Token Exchange Profile to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTokenExchangeProfileResponseContent
            Token Exchange Profile successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.token_exchange_profiles.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a Token Exchange Profile within your tenant.

        By using this feature, you agree to the applicable Free Trial terms in <a href="https://www.okta.com/legal/">Okta's Master Subscription Agreement</a>. It is your responsibility to securely validate the user's subject_token. See <a href="https://auth0.com/docs/authenticate/custom-token-exchange">User Guide</a> for more details.

        Parameters
        ----------
        id : str
            ID of the Token Exchange Profile to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.token_exchange_profiles.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = "Token Exchange Profile 1",
        subject_token_type: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update a Token Exchange Profile within your tenant.

        By using this feature, you agree to the applicable Free Trial terms in <a href="https://www.okta.com/legal/">Okta's Master Subscription Agreement</a>. It is your responsibility to securely validate the user's subject_token. See <a href="https://auth0.com/docs/authenticate/custom-token-exchange">User Guide</a> for more details.

        Parameters
        ----------
        id : str
            ID of the Token Exchange Profile to update.

        name : typing.Optional[str]
            Friendly name of this profile.

        subject_token_type : typing.Optional[str]
            Subject token type for this profile. When receiving a token exchange request on the Authentication API, the corresponding token exchange profile with a matching subject_token_type will be executed. This must be a URI.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.token_exchange_profiles.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id, name=name, subject_token_type=subject_token_type, request_options=request_options
        )
        return _response.data


class AsyncTokenExchangeProfilesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTokenExchangeProfilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTokenExchangeProfilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTokenExchangeProfilesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[TokenExchangeProfileResponseContent, ListTokenExchangeProfileResponseContent]:
        """
        Retrieve a list of all Token Exchange Profiles available in your tenant.

        By using this feature, you agree to the applicable Free Trial terms in <a href="https://www.okta.com/legal/">Okta’s Master Subscription Agreement</a>. It is your responsibility to securely validate the user’s subject_token. See <a href="https://auth0.com/docs/authenticate/custom-token-exchange">User Guide</a> for more details.

        This endpoint supports Checkpoint pagination. To search by checkpoint, use the following parameters:
        <ul>
        <li><code>from</code>: Optional id from which to start selection.</li>
        <li><code>take</code>: The total amount of entries to retrieve when using the from parameter. Defaults to 50.</li>
        </ul>

        <b>Note</b>: The first time you call this endpoint using checkpoint pagination, omit the <code>from</code> parameter. If there are more results, a <code>next</code> value is included in the response. You can use this for subsequent API calls. When <code>next</code> is no longer included in the response, no pages are remaining.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[TokenExchangeProfileResponseContent, ListTokenExchangeProfileResponseContent]
            Token Exchange Profile successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.token_exchange_profiles.list(
                from_="from",
                take=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(from_=from_, take=take, request_options=request_options)

    async def create(
        self,
        *,
        name: str = "Token Exchange Profile 1",
        subject_token_type: str,
        action_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateTokenExchangeProfileResponseContent:
        """
        Create a new Token Exchange Profile within your tenant.

        By using this feature, you agree to the applicable Free Trial terms in <a href="https://www.okta.com/legal/">Okta’s Master Subscription Agreement</a>. It is your responsibility to securely validate the user’s subject_token. See <a href="https://auth0.com/docs/authenticate/custom-token-exchange">User Guide</a> for more details.

        Parameters
        ----------
        name : str
            Friendly name of this profile.

        subject_token_type : str
            Subject token type for this profile. When receiving a token exchange request on the Authentication API, the corresponding token exchange profile with a matching subject_token_type will be executed. This must be a URI.

        action_id : str
            The ID of the Custom Token Exchange action to execute for this profile, in order to validate the subject_token. The action must use the custom-token-exchange trigger.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateTokenExchangeProfileResponseContent
            Token exchange profile successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.token_exchange_profiles.create(
                name="name",
                subject_token_type="subject_token_type",
                action_id="action_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name, subject_token_type=subject_token_type, action_id=action_id, request_options=request_options
        )
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTokenExchangeProfileResponseContent:
        """
        Retrieve details about a single Token Exchange Profile specified by ID.

        By using this feature, you agree to the applicable Free Trial terms in <a href="https://www.okta.com/legal/">Okta’s Master Subscription Agreement</a>. It is your responsibility to securely validate the user’s subject_token. See <a href="https://auth0.com/docs/authenticate/custom-token-exchange">User Guide</a> for more details.

        Parameters
        ----------
        id : str
            ID of the Token Exchange Profile to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTokenExchangeProfileResponseContent
            Token Exchange Profile successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.token_exchange_profiles.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a Token Exchange Profile within your tenant.

        By using this feature, you agree to the applicable Free Trial terms in <a href="https://www.okta.com/legal/">Okta's Master Subscription Agreement</a>. It is your responsibility to securely validate the user's subject_token. See <a href="https://auth0.com/docs/authenticate/custom-token-exchange">User Guide</a> for more details.

        Parameters
        ----------
        id : str
            ID of the Token Exchange Profile to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.token_exchange_profiles.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = "Token Exchange Profile 1",
        subject_token_type: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update a Token Exchange Profile within your tenant.

        By using this feature, you agree to the applicable Free Trial terms in <a href="https://www.okta.com/legal/">Okta's Master Subscription Agreement</a>. It is your responsibility to securely validate the user's subject_token. See <a href="https://auth0.com/docs/authenticate/custom-token-exchange">User Guide</a> for more details.

        Parameters
        ----------
        id : str
            ID of the Token Exchange Profile to update.

        name : typing.Optional[str]
            Friendly name of this profile.

        subject_token_type : typing.Optional[str]
            Subject token type for this profile. When receiving a token exchange request on the Authentication API, the corresponding token exchange profile with a matching subject_token_type will be executed. This must be a URI.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.token_exchange_profiles.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id, name=name, subject_token_type=subject_token_type, request_options=request_options
        )
        return _response.data
