# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .action_trigger import ActionTrigger


class ActionBase(UniversalBaseModel):
    """
    The action to which this version belongs.
    """

    id: typing.Optional[str] = pydantic.Field(default="910b1053-577f-4d81-a8c8-020e7319a38a")
    """
    The unique ID of the action.
    """

    name: typing.Optional[str] = pydantic.Field(default="my-action")
    """
    The name of an action.
    """

    supported_triggers: typing.Optional[typing.List[ActionTrigger]] = pydantic.Field(default=None)
    """
    The list of triggers that this action supports. At this time, an action can only target a single trigger at a time.
    """

    all_changes_deployed: typing.Optional[bool] = pydantic.Field(default=False)
    """
    True if all of an Action's contents have been deployed.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when this action was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when this action was updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
