# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .action import Action
from .action_trigger_type_enum import ActionTriggerTypeEnum


class ActionBinding(UniversalBaseModel):
    """
    Binding is the associative entity joining a trigger, and an action together.
    """

    id: typing.Optional[str] = pydantic.Field(default="4a881e22-0562-4178-bc91-b0f2b321dc13")
    """
    The unique ID of this binding.
    """

    trigger_id: typing.Optional[ActionTriggerTypeEnum] = None
    display_name: typing.Optional[str] = pydantic.Field(default="my-action-1")
    """
    The name of the binding.
    """

    action: typing.Optional[Action] = None
    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the binding was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the binding was updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
