# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .action_error import ActionError


class ActionExecutionResult(UniversalBaseModel):
    """
    Captures the results of a single action being executed.
    """

    action_name: typing.Optional[str] = pydantic.Field(default="my-action")
    """
    The name of the action that was executed.
    """

    error: typing.Optional[ActionError] = None
    started_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the action was started.
    """

    ended_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the action finished executing.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
