# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .action_binding_type_enum import ActionBindingTypeEnum
from .action_trigger_compatible_trigger import ActionTriggerCompatibleTrigger
from .action_trigger_type_enum import ActionTriggerTypeEnum


class ActionTrigger(UniversalBaseModel):
    id: ActionTriggerTypeEnum
    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of a trigger. v1, v2, etc.
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    status points to the trigger status.
    """

    runtimes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    runtimes supported by this trigger.
    """

    default_runtime: typing.Optional[str] = pydantic.Field(default=None)
    """
    Runtime that will be used when none is specified when creating an action.
    """

    compatible_triggers: typing.Optional[typing.List[ActionTriggerCompatibleTrigger]] = pydantic.Field(default=None)
    """
    compatible_triggers informs which other trigger supports the same event and api.
    """

    binding_policy: typing.Optional[ActionBindingTypeEnum] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
