# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ActionVersionDependency(UniversalBaseModel):
    """
    Dependency is an npm module. These values are used to produce an immutable artifact, which manifests as a layer_id.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    name is the name of the npm module, e.g. lodash
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    description is the version of the npm module, e.g. 4.17.1
    """

    registry_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    registry_url is an optional value used primarily for private npm registries.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
