# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .acul_filters import AculFilters
from .acul_head_tag import AculHeadTag
from .acul_rendering_mode_enum import AculRenderingModeEnum


class AculResponseContent(UniversalBaseModel):
    rendering_mode: typing.Optional[AculRenderingModeEnum] = None
    context_configuration: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Context values to make available
    """

    default_head_tags_disabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Override Universal Login default head tags
    """

    use_page_template: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Use page template with ACUL
    """

    head_tags: typing.Optional[typing.List[AculHeadTag]] = pydantic.Field(default=None)
    """
    An array of head tags
    """

    filters: typing.Optional[AculFilters] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
