# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .client_addons import ClientAddons
from .client_app_type_enum import ClientAppTypeEnum
from .client_async_approval_notifications_channels_api_post_configuration import (
    ClientAsyncApprovalNotificationsChannelsApiPostConfiguration,
)
from .client_authentication_method import ClientAuthenticationMethod
from .client_compliance_level_enum import ClientComplianceLevelEnum
from .client_default_organization import ClientDefaultOrganization
from .client_encryption_key import ClientEncryptionKey
from .client_jwt_configuration import ClientJwtConfiguration
from .client_metadata import ClientMetadata
from .client_mobile import ClientMobile
from .client_oidc_backchannel_logout_settings import ClientOidcBackchannelLogoutSettings
from .client_organization_discovery_enum import ClientOrganizationDiscoveryEnum
from .client_organization_require_behavior_enum import ClientOrganizationRequireBehaviorEnum
from .client_organization_usage_enum import ClientOrganizationUsageEnum
from .client_refresh_token_configuration import ClientRefreshTokenConfiguration
from .client_session_transfer_configuration import ClientSessionTransferConfiguration
from .client_signed_request_object_with_credential_id import ClientSignedRequestObjectWithCredentialId
from .client_signing_keys import ClientSigningKeys
from .client_token_endpoint_auth_method_enum import ClientTokenEndpointAuthMethodEnum
from .client_token_exchange_configuration import ClientTokenExchangeConfiguration
from .express_configuration import ExpressConfiguration
from .token_quota import TokenQuota


class Client(UniversalBaseModel):
    client_id: typing.Optional[str] = pydantic.Field(default="AaiyAPdpYdesoKnqjj8HJqRn4T5titww")
    """
    ID of this client.
    """

    tenant: typing.Optional[str] = pydantic.Field(default="")
    """
    Name of the tenant this client belongs to.
    """

    name: typing.Optional[str] = pydantic.Field(default="My application")
    """
    Name of this client (min length: 1 character, does not allow `<` or `>`).
    """

    description: typing.Optional[str] = pydantic.Field(default="")
    """
    Free text description of this client (max length: 140 characters).
    """

    global_: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="global")] = pydantic.Field(
        default=False
    )
    """
    Whether this is your global 'All Applications' client representing legacy tenant settings (true) or a regular client (false).
    """

    client_secret: typing.Optional[str] = pydantic.Field(
        default="MG_TNT2ver-SylNat-_VeMmd-4m0Waba0jr1troztBniSChEw0glxEmgEi2Kw40H"
    )
    """
    Client secret (which you must not make public).
    """

    app_type: typing.Optional[ClientAppTypeEnum] = None
    logo_uri: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL of the logo to display for this client. Recommended size is 150x150 pixels.
    """

    is_first_party: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Whether this client a first party client (true) or not (false).
    """

    oidc_conformant: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Whether this client conforms to <a href='https://auth0.com/docs/api-auth/tutorials/adoption'>strict OIDC specifications</a> (true) or uses legacy features (false).
    """

    callbacks: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Comma-separated list of URLs whitelisted for Auth0 to use as a callback to the client after authentication.
    """

    allowed_origins: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Comma-separated list of URLs allowed to make requests from JavaScript to Auth0 API (typically used with CORS). By default, all your callback URLs will be allowed. This field allows you to enter other origins if necessary. You can also use wildcards at the subdomain level (e.g., https://*.contoso.com). Query strings and hash information are not taken into account when validating these URLs.
    """

    web_origins: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Comma-separated list of allowed origins for use with <a href='https://auth0.com/docs/cross-origin-authentication'>Cross-Origin Authentication</a>, <a href='https://auth0.com/docs/flows/concepts/device-auth'>Device Flow</a>, and <a href='https://auth0.com/docs/protocols/oauth2#how-response-mode-works'>web message response mode</a>.
    """

    client_aliases: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of audiences/realms for SAML protocol. Used by the wsfed addon.
    """

    allowed_clients: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of allow clients and API ids that are allowed to make delegation requests. Empty means all all your clients are allowed.
    """

    allowed_logout_urls: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Comma-separated list of URLs that are valid to redirect to after logout from Auth0. Wildcards are allowed for subdomains.
    """

    session_transfer: typing.Optional[ClientSessionTransferConfiguration] = None
    oidc_logout: typing.Optional[ClientOidcBackchannelLogoutSettings] = None
    grant_types: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of grant types supported for this application. Can include `authorization_code`, `implicit`, `refresh_token`, `client_credentials`, `password`, `http://auth0.com/oauth/grant-type/password-realm`, `http://auth0.com/oauth/grant-type/mfa-oob`, `http://auth0.com/oauth/grant-type/mfa-otp`, `http://auth0.com/oauth/grant-type/mfa-recovery-code`, `urn:openid:params:grant-type:ciba`, `urn:ietf:params:oauth:grant-type:device_code`, and `urn:auth0:params:oauth:grant-type:token-exchange:federated-connection-access-token`.
    """

    jwt_configuration: typing.Optional[ClientJwtConfiguration] = None
    signing_keys: typing.Optional[ClientSigningKeys] = None
    encryption_key: typing.Optional[ClientEncryptionKey] = None
    sso: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Applies only to SSO clients and determines whether Auth0 will handle Single Sign On (true) or whether the Identity Provider will (false).
    """

    sso_disabled: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Whether Single Sign On is disabled (true) or enabled (true). Defaults to true.
    """

    cross_origin_authentication: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this client can be used to make cross-origin authentication requests (true) or it is not allowed to make such requests (false).
    """

    cross_origin_loc: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL of the location in your site where the cross origin verification takes place for the cross-origin auth flow when performing Auth in your own domain instead of Auth0 hosted login page.
    """

    custom_login_page_on: typing.Optional[bool] = pydantic.Field(default=True)
    """
    Whether a custom login page is to be used (true) or the default provided login page (false).
    """

    custom_login_page: typing.Optional[str] = pydantic.Field(default="")
    """
    The content (HTML, CSS, JS) of the custom login page.
    """

    custom_login_page_preview: typing.Optional[str] = pydantic.Field(default="")
    """
    The content (HTML, CSS, JS) of the custom login page. (Used on Previews)
    """

    form_template: typing.Optional[str] = pydantic.Field(default="")
    """
    HTML form template to be used for WS-Federation.
    """

    addons: typing.Optional[ClientAddons] = None
    token_endpoint_auth_method: typing.Optional[ClientTokenEndpointAuthMethodEnum] = None
    is_token_endpoint_ip_header_trusted: typing.Optional[bool] = pydantic.Field(default=False)
    """
    If true, trust that the IP specified in the `auth0-forwarded-for` header is the end-user's IP for brute-force-protection on token endpoint.
    """

    client_metadata: typing.Optional[ClientMetadata] = None
    mobile: typing.Optional[ClientMobile] = None
    initiate_login_uri: typing.Optional[str] = pydantic.Field(default=None)
    """
    Initiate login uri, must be https
    """

    refresh_token: typing.Optional[ClientRefreshTokenConfiguration] = None
    default_organization: typing.Optional[ClientDefaultOrganization] = None
    organization_usage: typing.Optional[ClientOrganizationUsageEnum] = None
    organization_require_behavior: typing.Optional[ClientOrganizationRequireBehaviorEnum] = None
    organization_discovery_methods: typing.Optional[typing.List[ClientOrganizationDiscoveryEnum]] = pydantic.Field(
        default=None
    )
    """
    Defines the available methods for organization discovery during the `pre_login_prompt`. Users can discover their organization either by `email`, `organization_name` or both.
    """

    client_authentication_methods: typing.Optional[ClientAuthenticationMethod] = None
    require_pushed_authorization_requests: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Makes the use of Pushed Authorization Requests mandatory for this client
    """

    require_proof_of_possession: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Makes the use of Proof-of-Possession mandatory for this client
    """

    signed_request_object: typing.Optional[ClientSignedRequestObjectWithCredentialId] = None
    compliance_level: typing.Optional[ClientComplianceLevelEnum] = None
    skip_non_verifiable_callback_uri_confirmation_prompt: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Controls whether a confirmation prompt is shown during login flows when the redirect URI uses non-verifiable callback URIs (for example, a custom URI schema such as `myapp://`, or `localhost`).
    If set to true, a confirmation prompt will not be shown. We recommend that this is set to false for improved protection from malicious apps.
    See https://auth0.com/docs/secure/security-guidance/measures-against-app-impersonation for more information.
    """

    token_exchange: typing.Optional[ClientTokenExchangeConfiguration] = None
    par_request_expiry: typing.Optional[int] = pydantic.Field(default=None)
    """
    Specifies how long, in seconds, a Pushed Authorization Request URI remains valid
    """

    token_quota: typing.Optional[TokenQuota] = None
    express_configuration: typing.Optional[ExpressConfiguration] = None
    resource_server_identifier: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier of the resource server that this client is linked to.
    """

    async_approval_notification_channels: typing.Optional[
        ClientAsyncApprovalNotificationsChannelsApiPostConfiguration
    ] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
