# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ClientAddonAzureBlob(UniversalBaseModel):
    """
    Azure Blob Storage addon configuration.
    """

    account_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="accountName")] = (
        pydantic.Field(default=None)
    )
    """
    Your Azure storage account name. Usually first segment in your Azure storage URL. e.g. `https://acme-org.blob.core.windows.net` would be the account name `acme-org`.
    """

    storage_access_key: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="storageAccessKey")] = (
        pydantic.Field(default=None)
    )
    """
    Access key associated with this storage account.
    """

    container_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="containerName")] = (
        pydantic.Field(default=None)
    )
    """
    Container to request a token for. e.g. `my-container`.
    """

    blob_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="blobName")] = pydantic.Field(
        default=None
    )
    """
    Entity to request a token for. e.g. `my-blob`. If blank the computed SAS will apply to the entire storage container.
    """

    expiration: typing.Optional[int] = pydantic.Field(default=None)
    """
    Expiration in minutes for the generated token (default of 5 minutes).
    """

    signed_identifier: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="signedIdentifier")] = (
        pydantic.Field(default=None)
    )
    """
    Shared access policy identifier defined in your storage account resource.
    """

    blob_read: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if the issued token has permission to read the content, properties, metadata and block list. Use the blob as the source of a copy operation.
    """

    blob_write: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if the issued token has permission to create or write content, properties, metadata, or block list. Snapshot or lease the blob. Resize the blob (page blob only). Use the blob as the destination of a copy operation within the same account.
    """

    blob_delete: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if the issued token has permission to delete the blob.
    """

    container_read: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if the issued token has permission to read the content, properties, metadata or block list of any blob in the container. Use any blob in the container as the source of a copy operation
    """

    container_write: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates that for any blob in the container if the issued token has permission to create or write content, properties, metadata, or block list. Snapshot or lease the blob. Resize the blob (page blob only). Use the blob as the destination of a copy operation within the same account.
    """

    container_delete: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if issued token has permission to delete any blob in the container.
    """

    container_list: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if the issued token has permission to list blobs in the container.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
