# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ClientAddonAzureSb(UniversalBaseModel):
    """
    Azure Storage Bus addon configuration.
    """

    namespace: typing.Optional[str] = pydantic.Field(default=None)
    """
    Your Azure Service Bus namespace. Usually the first segment of your Service Bus URL (e.g. `https://acme-org.servicebus.windows.net` would be `acme-org`).
    """

    sas_key_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="sasKeyName")] = pydantic.Field(
        default=None
    )
    """
    Your shared access policy name defined in your Service Bus entity.
    """

    sas_key: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="sasKey")] = pydantic.Field(
        default=None
    )
    """
    Primary Key associated with your shared access policy.
    """

    entity_path: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="entityPath")] = pydantic.Field(
        default=None
    )
    """
    Entity you want to request a token for. e.g. `my-queue`.'
    """

    expiration: typing.Optional[int] = pydantic.Field(default=None)
    """
    Optional expiration in minutes for the generated token. Defaults to 5 minutes.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
