# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ClientAddonFirebase(UniversalBaseModel):
    """
    Google Firebase addon configuration.
    """

    secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    Google Firebase Secret. (SDK 2 only).
    """

    private_key_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional ID of the private key to obtain kid header in the issued token (SDK v3+ tokens only).
    """

    private_key: typing.Optional[str] = pydantic.Field(default=None)
    """
    Private Key for signing the token (SDK v3+ tokens only).
    """

    client_email: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the Service Account you have created (shown as `client_email` in the generated JSON file, SDK v3+ tokens only).
    """

    lifetime_in_seconds: typing.Optional[int] = pydantic.Field(default=None)
    """
    Optional expiration in seconds for the generated token. Defaults to 3600 seconds (SDK v3+ tokens only).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
