# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ClientAddonLayer(UniversalBaseModel):
    """
    Layer addon configuration.
    """

    provider_id: typing_extensions.Annotated[str, FieldMetadata(alias="providerId")] = pydantic.Field()
    """
    Provider ID of your Layer account
    """

    key_id: typing_extensions.Annotated[str, FieldMetadata(alias="keyId")] = pydantic.Field()
    """
    Authentication Key identifier used to sign the Layer token.
    """

    private_key: typing_extensions.Annotated[str, FieldMetadata(alias="privateKey")] = pydantic.Field()
    """
    Private key for signing the Layer token.
    """

    principal: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the property used as the unique user id in Layer. If not specified `user_id` is used.
    """

    expiration: typing.Optional[int] = pydantic.Field(default=None)
    """
    Optional expiration in minutes for the generated token. Defaults to 5 minutes.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
