# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ClientAddonSalesforceApi(UniversalBaseModel):
    """
    Salesforce API addon configuration.
    """

    clientid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Consumer Key assigned by Salesforce to the Connected App.
    """

    principal: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the property in the user object that maps to a Salesforce username. e.g. `email`.
    """

    community_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="communityName")] = (
        pydantic.Field(default=None)
    )
    """
    Community name.
    """

    community_url_section: typing.Optional[str] = pydantic.Field(default=None)
    """
    Community url section.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
