# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .client_addon_saml_mapping import ClientAddonSamlMapping


class ClientAddonSaml(UniversalBaseModel):
    """
    SAML2 addon indicator (no configuration settings needed for SAML2 addon).
    """

    mappings: typing.Optional[ClientAddonSamlMapping] = None
    audience: typing.Optional[str] = None
    recipient: typing.Optional[str] = None
    create_upn_claim: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="createUpnClaim")] = None
    map_unknown_claims_as_is: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="mapUnknownClaimsAsIs")
    ] = None
    passthrough_claims_with_no_mapping: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="passthroughClaimsWithNoMapping")
    ] = None
    map_identities: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="mapIdentities")] = None
    signature_algorithm: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="signatureAlgorithm")
    ] = None
    digest_algorithm: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="digestAlgorithm")] = None
    issuer: typing.Optional[str] = None
    destination: typing.Optional[str] = None
    lifetime_in_seconds: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="lifetimeInSeconds")] = (
        None
    )
    sign_response: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="signResponse")] = None
    name_identifier_format: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="nameIdentifierFormat")
    ] = None
    name_identifier_probes: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="nameIdentifierProbes")
    ] = None
    authn_context_class_ref: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="authnContextClassRef")
    ] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
