# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ClientAddonSapapi(UniversalBaseModel):
    """
    SAP API addon configuration.
    """

    clientid: typing.Optional[str] = pydantic.Field(default=None)
    """
    If activated in the OAuth 2.0 client configuration (transaction SOAUTH2) the SAML attribute client_id must be set and equal the client_id form parameter of the access token request.
    """

    username_attribute: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="usernameAttribute")] = (
        pydantic.Field(default=None)
    )
    """
    Name of the property in the user object that maps to a SAP username. e.g. `email`.
    """

    token_endpoint_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="tokenEndpointUrl")] = (
        pydantic.Field(default=None)
    )
    """
    Your SAP OData server OAuth2 token endpoint URL.
    """

    scope: typing.Optional[str] = pydantic.Field(default=None)
    """
    Requested scope for SAP APIs.
    """

    service_password: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="servicePassword")] = (
        pydantic.Field(default=None)
    )
    """
    Service account password to use to authenticate API calls to the token endpoint.
    """

    name_identifier_format: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="nameIdentifierFormat")
    ] = pydantic.Field(default=None)
    """
    NameID element of the Subject which can be used to express the user's identity. Defaults to `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
