# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ClientAddonSentry(UniversalBaseModel):
    """
    Sentry SSO configuration.
    """

    org_slug: typing.Optional[str] = pydantic.Field(default=None)
    """
    Generated slug for your Sentry organization. Found in your Sentry URL. e.g. `https://sentry.acme.com/acme-org/` would be `acme-org`.
    """

    base_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL prefix only if running Sentry Community Edition, otherwise leave should be blank.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
