# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .client_addon_aws import ClientAddonAws
from .client_addon_azure_blob import ClientAddonAzureBlob
from .client_addon_azure_sb import ClientAddonAzureSb
from .client_addon_box import ClientAddonBox
from .client_addon_cloud_bees import ClientAddonCloudBees
from .client_addon_concur import ClientAddonConcur
from .client_addon_dropbox import ClientAddonDropbox
from .client_addon_echo_sign import ClientAddonEchoSign
from .client_addon_egnyte import ClientAddonEgnyte
from .client_addon_firebase import ClientAddonFirebase
from .client_addon_layer import ClientAddonLayer
from .client_addon_mscrm import ClientAddonMscrm
from .client_addon_new_relic import ClientAddonNewRelic
from .client_addon_oag import ClientAddonOag
from .client_addon_office_365 import ClientAddonOffice365
from .client_addon_rms import ClientAddonRms
from .client_addon_salesforce import ClientAddonSalesforce
from .client_addon_salesforce_api import ClientAddonSalesforceApi
from .client_addon_salesforce_sandbox_api import ClientAddonSalesforceSandboxApi
from .client_addon_saml import ClientAddonSaml
from .client_addon_sapapi import ClientAddonSapapi
from .client_addon_sentry import ClientAddonSentry
from .client_addon_share_point import ClientAddonSharePoint
from .client_addon_slack import ClientAddonSlack
from .client_addon_spring_cm import ClientAddonSpringCm
from .client_addon_sso_integration import ClientAddonSsoIntegration
from .client_addon_wams import ClientAddonWams
from .client_addon_ws_fed import ClientAddonWsFed
from .client_addon_zendesk import ClientAddonZendesk
from .client_addon_zoom import ClientAddonZoom


class ClientAddons(UniversalBaseModel):
    """
    Addons enabled for this client and their associated configurations.
    """

    aws: typing.Optional[ClientAddonAws] = None
    azure_blob: typing.Optional[ClientAddonAzureBlob] = None
    azure_sb: typing.Optional[ClientAddonAzureSb] = None
    rms: typing.Optional[ClientAddonRms] = None
    mscrm: typing.Optional[ClientAddonMscrm] = None
    slack: typing.Optional[ClientAddonSlack] = None
    sentry: typing.Optional[ClientAddonSentry] = None
    box: typing.Optional[ClientAddonBox] = None
    cloudbees: typing.Optional[ClientAddonCloudBees] = None
    concur: typing.Optional[ClientAddonConcur] = None
    dropbox: typing.Optional[ClientAddonDropbox] = None
    echosign: typing.Optional[ClientAddonEchoSign] = None
    egnyte: typing.Optional[ClientAddonEgnyte] = None
    firebase: typing.Optional[ClientAddonFirebase] = None
    newrelic: typing.Optional[ClientAddonNewRelic] = None
    office_365: typing_extensions.Annotated[typing.Optional[ClientAddonOffice365], FieldMetadata(alias="office365")] = (
        None
    )
    salesforce: typing.Optional[ClientAddonSalesforce] = None
    salesforce_api: typing.Optional[ClientAddonSalesforceApi] = None
    salesforce_sandbox_api: typing.Optional[ClientAddonSalesforceSandboxApi] = None
    samlp: typing.Optional[ClientAddonSaml] = None
    layer: typing.Optional[ClientAddonLayer] = None
    sap_api: typing.Optional[ClientAddonSapapi] = None
    sharepoint: typing.Optional[ClientAddonSharePoint] = None
    springcm: typing.Optional[ClientAddonSpringCm] = None
    wams: typing.Optional[ClientAddonWams] = None
    wsfed: typing.Optional[ClientAddonWsFed] = None
    zendesk: typing.Optional[ClientAddonZendesk] = None
    zoom: typing.Optional[ClientAddonZoom] = None
    sso_integration: typing.Optional[ClientAddonSsoIntegration] = None
    oag: typing.Optional[ClientAddonOag] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
