# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .client_jwt_configuration_scopes import ClientJwtConfigurationScopes
from .signing_algorithm_enum import SigningAlgorithmEnum


class ClientJwtConfiguration(UniversalBaseModel):
    """
    Configuration related to JWTs for the client.
    """

    lifetime_in_seconds: typing.Optional[int] = pydantic.Field(default=36000)
    """
    Number of seconds the JWT will be valid for (affects `exp` claim).
    """

    secret_encoded: typing.Optional[bool] = pydantic.Field(default=True)
    """
    Whether the client secret is base64 encoded (true) or unencoded (false).
    """

    scopes: typing.Optional[ClientJwtConfigurationScopes] = None
    alg: typing.Optional[SigningAlgorithmEnum] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
