# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ClientMobileAndroid(UniversalBaseModel):
    """
    Android native app configuration.
    """

    app_package_name: typing.Optional[str] = pydantic.Field(default="")
    """
    App package name found in AndroidManifest.xml.
    """

    sha_256_cert_fingerprints: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="sha256_cert_fingerprints")
    ] = pydantic.Field(default=None)
    """
    SHA256 fingerprints of the app's signing certificate. Multiple fingerprints can be used to support different versions of your app, such as debug and production builds.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
