# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ClientMobileiOs(UniversalBaseModel):
    """
    iOS native app configuration.
    """

    team_id: typing.Optional[str] = pydantic.Field(default="")
    """
    Identifier assigned to the Apple account that signs and uploads the app to the store.
    """

    app_bundle_identifier: typing.Optional[str] = pydantic.Field(default="")
    """
    Assigned by developer to the app as its unique identifier inside the store. Usually this is a reverse domain plus the app name, e.g. `com.you.MyApp`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
