# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .refresh_token_expiration_type_enum import RefreshTokenExpirationTypeEnum
from .refresh_token_rotation_type_enum import RefreshTokenRotationTypeEnum


class ClientRefreshTokenConfiguration(UniversalBaseModel):
    """
    Refresh token configuration
    """

    rotation_type: RefreshTokenRotationTypeEnum
    expiration_type: RefreshTokenExpirationTypeEnum
    leeway: typing.Optional[int] = pydantic.Field(default=0)
    """
    Period in seconds where the previous refresh token can be exchanged without triggering breach detection
    """

    token_lifetime: typing.Optional[int] = pydantic.Field(default=None)
    """
    Period (in seconds) for which refresh tokens will remain valid
    """

    infinite_token_lifetime: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Prevents tokens from having a set lifetime when `true` (takes precedence over `token_lifetime` values)
    """

    idle_token_lifetime: typing.Optional[int] = pydantic.Field(default=None)
    """
    Period (in seconds) for which refresh tokens will remain valid without use
    """

    infinite_idle_token_lifetime: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Prevents tokens from expiring without use when `true` (takes precedence over `idle_token_lifetime` values)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
