# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .client_session_transfer_allowed_authentication_methods_enum import (
    ClientSessionTransferAllowedAuthenticationMethodsEnum,
)
from .client_session_transfer_device_binding_enum import ClientSessionTransferDeviceBindingEnum


class ClientSessionTransferConfiguration(UniversalBaseModel):
    """
    Native to Web SSO Configuration
    """

    can_create_session_transfer_token: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Indicates whether an app can issue a Session Transfer Token through Token Exchange. If set to 'false', the app will not be able to issue a Session Transfer Token. Usually configured in the native application.
    """

    enforce_cascade_revocation: typing.Optional[bool] = pydantic.Field(default=True)
    """
    Indicates whether revoking the parent Refresh Token that initiated a Native to Web flow and was used to issue a Session Transfer Token should trigger a cascade revocation affecting its dependent child entities. Usually configured in the native application.
    """

    allowed_authentication_methods: typing.Optional[
        typing.List[ClientSessionTransferAllowedAuthenticationMethodsEnum]
    ] = pydantic.Field(default=None)
    """
    Indicates whether an app can create a session from a Session Transfer Token received via indicated methods. Can include `cookie` and/or `query`. Usually configured in the web application.
    """

    enforce_device_binding: typing.Optional[ClientSessionTransferDeviceBindingEnum] = None
    allow_refresh_token: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Indicates whether Refresh Tokens are allowed to be issued when authenticating with a Session Transfer Token. Usually configured in the web application.
    """

    enforce_online_refresh_tokens: typing.Optional[bool] = pydantic.Field(default=True)
    """
    Indicates whether Refresh Tokens created during a native-to-web session are tied to that session's lifetime. This determines if such refresh tokens should be automatically revoked when their corresponding sessions are. Usually configured in the web application.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
