# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .public_key_credential import PublicKeyCredential


class ClientSignedRequestObjectWithPublicKey(UniversalBaseModel):
    """
    JWT-secured Authorization Requests (JAR) settings.
    """

    required: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Indicates whether the JAR requests are mandatory
    """

    credentials: typing.Optional[typing.List[PublicKeyCredential]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
