# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ClientSigningKey(UniversalBaseModel):
    pkcs_7: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="pkcs7")] = pydantic.Field(default="")
    """
    Signing certificate public key and chain in PKCS#7 (.P7B) format.
    """

    cert: typing.Optional[str] = pydantic.Field(default="")
    """
    Signing certificate public key in X.509 (.CER) format.
    """

    subject: typing.Optional[str] = pydantic.Field(default="")
    """
    Subject name for this certificate in the format `/CN={domain}`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
