# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .connected_account_access_type_enum import ConnectedAccountAccessTypeEnum


class ConnectedAccount(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The unique identifier for the connected account.
    """

    connection: str = pydantic.Field()
    """
    The name of the connection associated with the account.
    """

    connection_id: str = pydantic.Field()
    """
    The unique identifier of the connection associated with the account.
    """

    strategy: str = pydantic.Field()
    """
    The authentication strategy used by the connection.
    """

    access_type: ConnectedAccountAccessTypeEnum = "offline"
    scopes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The scopes granted for this connected account.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    ISO 8601 timestamp when the connected account was created.
    """

    expires_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    ISO 8601 timestamp when the connected account expires.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
