# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ConnectionForOrganization(UniversalBaseModel):
    """
    Connection to be added to the organization.
    """

    connection_id: str = pydantic.Field()
    """
    ID of the connection.
    """

    assign_membership_on_login: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When true, all users that log in with this connection will be automatically granted membership in the organization. When false, users must be granted membership in the organization before logging in with this connection.
    """

    show_as_button: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Determines whether a connection should be displayed on this organization’s login prompt. Only applicable for enterprise connections. Default: true.
    """

    is_signup_enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Determines whether organization signup should be enabled for this organization connection. Only applicable for database connections. Default: false.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
